/*!
[config]
name: Test float tan built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: tan float1
kernel_name: test_1_tan_float
global_size: 7 0 0

arg_out: 0 buffer float[7] 0.0 1.0 8.742278000372508e-08 1.7320508075688772 -1.0 -1.2785033191454012 nan  tolerance 5 ulp
arg_in: 1 buffer float[7] 0.0 0.7853981633974483 3.1415927410125732 1.0471975511965976 2.356194490192345 2.234567 nan 

[test]
name: tan float2
kernel_name: test_2_tan_float
global_size: 7 0 0

arg_out: 0 buffer float[14] 0.0 0.0 1.0 1.0 8.742278000372508e-08 8.742278000372508e-08 1.7320508075688772 1.7320508075688772 -1.0 -1.0 -1.2785033191454012 -1.2785033191454012 nan nan  tolerance 5 ulp
arg_in: 1 buffer float[14] 0.0 0.0 0.7853981633974483 0.7853981633974483 3.1415927410125732 3.1415927410125732 1.0471975511965976 1.0471975511965976 2.356194490192345 2.356194490192345 2.234567 2.234567 nan nan 

[test]
name: tan float4
kernel_name: test_4_tan_float
global_size: 7 0 0

arg_out: 0 buffer float[28] 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 -1.0 -1.0 -1.0 -1.0 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 nan nan nan nan  tolerance 5 ulp
arg_in: 1 buffer float[28] 0.0 0.0 0.0 0.0 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.234567 2.234567 2.234567 2.234567 nan nan nan nan 

[test]
name: tan float8
kernel_name: test_8_tan_float
global_size: 7 0 0

arg_out: 0 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 nan nan nan nan nan nan nan nan  tolerance 5 ulp
arg_in: 1 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 nan nan nan nan nan nan nan nan 

[test]
name: tan float16
kernel_name: test_16_tan_float
global_size: 7 0 0

arg_out: 0 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 8.742278000372508e-08 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 -1.2785033191454012 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 5 ulp
arg_in: 1 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 0.7853981633974483 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 3.1415927410125732 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 1.0471975511965976 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.356194490192345 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_tan_float(global float* out, global float* in0){
  out[get_global_id(0)] = tan(in0[get_global_id(0)]);
}

kernel void test_2_tan_float(global float* out, global float* in0){
  vstore2(tan(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_tan_float(global float* out, global float* in0){
  vstore4(tan(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_tan_float(global float* out, global float* in0){
  vstore8(tan(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_tan_float(global float* out, global float* in0){
  vstore16(tan(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

