/*!
[config]
name: Test float sqrt built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: sqrt float1
kernel_name: test_1_sqrt_float
global_size: 9 0 0

arg_out: 0 buffer float[9] 1.0 2.0 6.0 2.5 nan 4.0 0.0 2.6457513110645907 1.7724538509055159  tolerance 3 ulp
arg_in: 1 buffer float[9] 1.0 4.0 36.0 6.25 nan 16.0 0.0 7.0 3.141592653589793 

[test]
name: sqrt float2
kernel_name: test_2_sqrt_float
global_size: 9 0 0

arg_out: 0 buffer float[18] 1.0 1.0 2.0 2.0 6.0 6.0 2.5 2.5 nan nan 4.0 4.0 0.0 0.0 2.6457513110645907 2.6457513110645907 1.7724538509055159 1.7724538509055159  tolerance 3 ulp
arg_in: 1 buffer float[18] 1.0 1.0 4.0 4.0 36.0 36.0 6.25 6.25 nan nan 16.0 16.0 0.0 0.0 7.0 7.0 3.141592653589793 3.141592653589793 

[test]
name: sqrt float4
kernel_name: test_4_sqrt_float
global_size: 9 0 0

arg_out: 0 buffer float[36] 1.0 1.0 1.0 1.0 2.0 2.0 2.0 2.0 6.0 6.0 6.0 6.0 2.5 2.5 2.5 2.5 nan nan nan nan 4.0 4.0 4.0 4.0 0.0 0.0 0.0 0.0 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159  tolerance 3 ulp
arg_in: 1 buffer float[36] 1.0 1.0 1.0 1.0 4.0 4.0 4.0 4.0 36.0 36.0 36.0 36.0 6.25 6.25 6.25 6.25 nan nan nan nan 16.0 16.0 16.0 16.0 0.0 0.0 0.0 0.0 7.0 7.0 7.0 7.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 

[test]
name: sqrt float8
kernel_name: test_8_sqrt_float
global_size: 9 0 0

arg_out: 0 buffer float[72] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 6.0 6.0 6.0 6.0 6.0 6.0 6.0 6.0 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 nan nan nan nan nan nan nan nan 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159  tolerance 3 ulp
arg_in: 1 buffer float[72] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 nan nan nan nan nan nan nan nan 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 

[test]
name: sqrt float16
kernel_name: test_16_sqrt_float
global_size: 9 0 0

arg_out: 0 buffer float[144] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 6.0 6.0 6.0 6.0 6.0 6.0 6.0 6.0 6.0 6.0 6.0 6.0 6.0 6.0 6.0 6.0 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 2.6457513110645907 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159  tolerance 3 ulp
arg_in: 1 buffer float[144] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 

!*/

kernel void test_1_sqrt_float(global float* out, global float* in0){
  out[get_global_id(0)] = sqrt(in0[get_global_id(0)]);
}

kernel void test_2_sqrt_float(global float* out, global float* in0){
  vstore2(sqrt(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_sqrt_float(global float* out, global float* in0){
  vstore4(sqrt(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_sqrt_float(global float* out, global float* in0){
  vstore8(sqrt(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_sqrt_float(global float* out, global float* in0){
  vstore16(sqrt(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

