/*!
[config]
name: Test float sinpi built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: sinpi float1
kernel_name: test_1_sinpi_float
global_size: 12 0 0

arg_out: 0 buffer float[12] 0.0 0.0 -0.9753679720836315 0.7855328097128459 0.7768535654959169 -0.3781801107252045 0.0 0.0 0.0 0.0 0.0 nan  tolerance 4 ulp
arg_in: 1 buffer float[12] 0.0 1.0 1.5707963267948966 4.71238898038469 6.283185307179586 1.12345 7.0 8.0 1048576.0 16777216.0 1.329227995784916e+36 nan 

[test]
name: sinpi float2
kernel_name: test_2_sinpi_float
global_size: 12 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 -0.9753679720836315 -0.9753679720836315 0.7855328097128459 0.7855328097128459 0.7768535654959169 0.7768535654959169 -0.3781801107252045 -0.3781801107252045 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan  tolerance 4 ulp
arg_in: 1 buffer float[24] 0.0 0.0 1.0 1.0 1.5707963267948966 1.5707963267948966 4.71238898038469 4.71238898038469 6.283185307179586 6.283185307179586 1.12345 1.12345 7.0 7.0 8.0 8.0 1048576.0 1048576.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 nan nan 

[test]
name: sinpi float4
kernel_name: test_4_sinpi_float
global_size: 12 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[48] 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 1.12345 1.12345 1.12345 1.12345 7.0 7.0 7.0 7.0 8.0 8.0 8.0 8.0 1048576.0 1048576.0 1048576.0 1048576.0 16777216.0 16777216.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 nan nan nan nan 

[test]
name: sinpi float8
kernel_name: test_8_sinpi_float
global_size: 12 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 8.0 8.0 8.0 8.0 8.0 8.0 8.0 8.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 nan nan nan nan nan nan nan nan 

[test]
name: sinpi float16
kernel_name: test_16_sinpi_float
global_size: 12 0 0

arg_out: 0 buffer float[192] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 -0.9753679720836315 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7855328097128459 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 0.7768535654959169 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 -0.3781801107252045 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[192] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 8.0 8.0 8.0 8.0 8.0 8.0 8.0 8.0 8.0 8.0 8.0 8.0 8.0 8.0 8.0 8.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_sinpi_float(global float* out, global float* in0){
  out[get_global_id(0)] = sinpi(in0[get_global_id(0)]);
}

kernel void test_2_sinpi_float(global float* out, global float* in0){
  vstore2(sinpi(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_sinpi_float(global float* out, global float* in0){
  vstore4(sinpi(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_sinpi_float(global float* out, global float* in0){
  vstore8(sinpi(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_sinpi_float(global float* out, global float* in0){
  vstore16(sinpi(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

