/*!
[config]
name: Test float sinh built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: sinh float1
kernel_name: test_1_sinh_float
global_size: 5 0 0

arg_out: 0 buffer float[5] 0.0 0.1237706408130359 inf -inf nan  tolerance 4 ulp
arg_in: 1 buffer float[5] 0.0 0.123456789 inf -inf nan 

[test]
name: sinh float2
kernel_name: test_2_sinh_float
global_size: 5 0 0

arg_out: 0 buffer float[10] 0.0 0.0 0.1237706408130359 0.1237706408130359 inf inf -inf -inf nan nan  tolerance 4 ulp
arg_in: 1 buffer float[10] 0.0 0.0 0.123456789 0.123456789 inf inf -inf -inf nan nan 

[test]
name: sinh float4
kernel_name: test_4_sinh_float
global_size: 5 0 0

arg_out: 0 buffer float[20] 0.0 0.0 0.0 0.0 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 inf inf inf inf -inf -inf -inf -inf nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[20] 0.0 0.0 0.0 0.0 0.123456789 0.123456789 0.123456789 0.123456789 inf inf inf inf -inf -inf -inf -inf nan nan nan nan 

[test]
name: sinh float8
kernel_name: test_8_sinh_float
global_size: 5 0 0

arg_out: 0 buffer float[40] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[40] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf nan nan nan nan nan nan nan nan 

[test]
name: sinh float16
kernel_name: test_16_sinh_float
global_size: 5 0 0

arg_out: 0 buffer float[80] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 0.1237706408130359 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[80] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_sinh_float(global float* out, global float* in0){
  out[get_global_id(0)] = sinh(in0[get_global_id(0)]);
}

kernel void test_2_sinh_float(global float* out, global float* in0){
  vstore2(sinh(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_sinh_float(global float* out, global float* in0){
  vstore4(sinh(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_sinh_float(global float* out, global float* in0){
  vstore8(sinh(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_sinh_float(global float* out, global float* in0){
  vstore16(sinh(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

