/*!
[config]
name: Test float sin built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: sin float1
kernel_name: test_1_sin_float
global_size: 12 0 0

arg_out: 0 buffer float[12] 0.0 1.0 -8.742278000372475e-08 -1.0 1.7484556000744883e-07 0.7876747576515583 0.6569865987187891 0.9893582466233818 0.3304931400217347 -0.7795636732177778 0.377820109360752 nan  tolerance 4 ulp
arg_in: 1 buffer float[12] 0.0 1.5707963267948966 3.141592653589793 4.71238898038469 6.283185307179586 2.234567 7 8 1048576.0 16777216.0 1.329227995784916e+36 nan 

[test]
name: sin float2
kernel_name: test_2_sin_float
global_size: 12 0 0

arg_out: 0 buffer float[24] 0.0 0.0 1.0 1.0 -8.742278000372475e-08 -8.742278000372475e-08 -1.0 -1.0 1.7484556000744883e-07 1.7484556000744883e-07 0.7876747576515583 0.7876747576515583 0.6569865987187891 0.6569865987187891 0.9893582466233818 0.9893582466233818 0.3304931400217347 0.3304931400217347 -0.7795636732177778 -0.7795636732177778 0.377820109360752 0.377820109360752 nan nan  tolerance 4 ulp
arg_in: 1 buffer float[24] 0.0 0.0 1.5707963267948966 1.5707963267948966 3.141592653589793 3.141592653589793 4.71238898038469 4.71238898038469 6.283185307179586 6.283185307179586 2.234567 2.234567 7 7 8 8 1048576.0 1048576.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 nan nan 

[test]
name: sin float4
kernel_name: test_4_sin_float
global_size: 12 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -1.0 -1.0 -1.0 -1.0 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[48] 0.0 0.0 0.0 0.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 2.234567 2.234567 2.234567 2.234567 7 7 7 7 8 8 8 8 1048576.0 1048576.0 1048576.0 1048576.0 16777216.0 16777216.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 nan nan nan nan 

[test]
name: sin float8
kernel_name: test_8_sin_float
global_size: 12 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 7 7 7 7 7 7 7 7 8 8 8 8 8 8 8 8 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 nan nan nan nan nan nan nan nan 

[test]
name: sin float16
kernel_name: test_16_sin_float
global_size: 12 0 0

arg_out: 0 buffer float[192] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -8.742278000372475e-08 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 1.7484556000744883e-07 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.7876747576515583 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.6569865987187891 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.9893582466233818 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 0.3304931400217347 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 -0.7795636732177778 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 0.377820109360752 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[192] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_sin_float(global float* out, global float* in0){
  out[get_global_id(0)] = sin(in0[get_global_id(0)]);
}

kernel void test_2_sin_float(global float* out, global float* in0){
  vstore2(sin(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_sin_float(global float* out, global float* in0){
  vstore4(sin(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_sin_float(global float* out, global float* in0){
  vstore8(sin(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_sin_float(global float* out, global float* in0){
  vstore16(sin(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

