/*!
[config]
name: Test float rsqrt built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: rsqrt float1
kernel_name: test_1_rsqrt_float
global_size: 9 0 0

arg_out: 0 buffer float[9] 1.0 0.5 0.16666666666666666 0.4 nan 0.25 inf 0.3779644730092272 0.5641895835477563  tolerance 2 ulp
arg_in: 1 buffer float[9] 1.0 4.0 36.0 6.25 nan 16.0 0.0 7.0 3.141592653589793 

[test]
name: rsqrt float2
kernel_name: test_2_rsqrt_float
global_size: 9 0 0

arg_out: 0 buffer float[18] 1.0 1.0 0.5 0.5 0.16666666666666666 0.16666666666666666 0.4 0.4 nan nan 0.25 0.25 inf inf 0.3779644730092272 0.3779644730092272 0.5641895835477563 0.5641895835477563  tolerance 2 ulp
arg_in: 1 buffer float[18] 1.0 1.0 4.0 4.0 36.0 36.0 6.25 6.25 nan nan 16.0 16.0 0.0 0.0 7.0 7.0 3.141592653589793 3.141592653589793 

[test]
name: rsqrt float4
kernel_name: test_4_rsqrt_float
global_size: 9 0 0

arg_out: 0 buffer float[36] 1.0 1.0 1.0 1.0 0.5 0.5 0.5 0.5 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.4 0.4 0.4 0.4 nan nan nan nan 0.25 0.25 0.25 0.25 inf inf inf inf 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563  tolerance 2 ulp
arg_in: 1 buffer float[36] 1.0 1.0 1.0 1.0 4.0 4.0 4.0 4.0 36.0 36.0 36.0 36.0 6.25 6.25 6.25 6.25 nan nan nan nan 16.0 16.0 16.0 16.0 0.0 0.0 0.0 0.0 7.0 7.0 7.0 7.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 

[test]
name: rsqrt float8
kernel_name: test_8_rsqrt_float
global_size: 9 0 0

arg_out: 0 buffer float[72] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 nan nan nan nan nan nan nan nan 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 inf inf inf inf inf inf inf inf 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563  tolerance 2 ulp
arg_in: 1 buffer float[72] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 nan nan nan nan nan nan nan nan 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 

[test]
name: rsqrt float16
kernel_name: test_16_rsqrt_float
global_size: 9 0 0

arg_out: 0 buffer float[144] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.16666666666666666 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.3779644730092272 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563 0.5641895835477563  tolerance 2 ulp
arg_in: 1 buffer float[144] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 36.0 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 6.25 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 16.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 7.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 

!*/

kernel void test_1_rsqrt_float(global float* out, global float* in0){
  out[get_global_id(0)] = rsqrt(in0[get_global_id(0)]);
}

kernel void test_2_rsqrt_float(global float* out, global float* in0){
  vstore2(rsqrt(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_rsqrt_float(global float* out, global float* in0){
  vstore4(rsqrt(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_rsqrt_float(global float* out, global float* in0){
  vstore8(rsqrt(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_rsqrt_float(global float* out, global float* in0){
  vstore16(rsqrt(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

