/*!
[config]
name: Test float round built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: round float1
kernel_name: test_1_round_float
global_size: 9 0 0

arg_out: 0 buffer float[9] 1.0 -1.0 0.0 -0.0 nan -4.0 2.0 0.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[9] 0.5 -0.5 0.0 -0.0 nan -3.99 1.5 0.4 0.6 

[test]
name: round float2
kernel_name: test_2_round_float
global_size: 9 0 0

arg_out: 0 buffer float[18] 1.0 1.0 -1.0 -1.0 0.0 0.0 -0.0 -0.0 nan nan -4.0 -4.0 2.0 2.0 0.0 0.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[18] 0.5 0.5 -0.5 -0.5 0.0 0.0 -0.0 -0.0 nan nan -3.99 -3.99 1.5 1.5 0.4 0.4 0.6 0.6 

[test]
name: round float4
kernel_name: test_4_round_float
global_size: 9 0 0

arg_out: 0 buffer float[36] 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan -4.0 -4.0 -4.0 -4.0 2.0 2.0 2.0 2.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[36] 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan -3.99 -3.99 -3.99 -3.99 1.5 1.5 1.5 1.5 0.4 0.4 0.4 0.4 0.6 0.6 0.6 0.6 

[test]
name: round float8
kernel_name: test_8_round_float
global_size: 9 0 0

arg_out: 0 buffer float[72] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan nan nan nan nan -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[72] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan nan nan nan nan -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 

[test]
name: round float16
kernel_name: test_16_round_float
global_size: 9 0 0

arg_out: 0 buffer float[144] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[144] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 

!*/

kernel void test_1_round_float(global float* out, global float* in0){
  out[get_global_id(0)] = round(in0[get_global_id(0)]);
}

kernel void test_2_round_float(global float* out, global float* in0){
  vstore2(round(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_round_float(global float* out, global float* in0){
  vstore4(round(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_round_float(global float* out, global float* in0){
  vstore8(round(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_round_float(global float* out, global float* in0){
  vstore16(round(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

