/*!
[config]
name: Test float rint built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: rint float1
kernel_name: test_1_rint_float
global_size: 9 0 0

arg_out: 0 buffer float[9] 0.0 -0.0 1.0 -1.0 nan -4.0 2.0 0.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[9] 0.5 -0.5 0.6 -0.6 nan -3.99 1.5 0.4 0.6 

[test]
name: rint float2
kernel_name: test_2_rint_float
global_size: 9 0 0

arg_out: 0 buffer float[18] 0.0 0.0 -0.0 -0.0 1.0 1.0 -1.0 -1.0 nan nan -4.0 -4.0 2.0 2.0 0.0 0.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[18] 0.5 0.5 -0.5 -0.5 0.6 0.6 -0.6 -0.6 nan nan -3.99 -3.99 1.5 1.5 0.4 0.4 0.6 0.6 

[test]
name: rint float4
kernel_name: test_4_rint_float
global_size: 9 0 0

arg_out: 0 buffer float[36] 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan -4.0 -4.0 -4.0 -4.0 2.0 2.0 2.0 2.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[36] 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 0.6 0.6 0.6 0.6 -0.6 -0.6 -0.6 -0.6 nan nan nan nan -3.99 -3.99 -3.99 -3.99 1.5 1.5 1.5 1.5 0.4 0.4 0.4 0.4 0.6 0.6 0.6 0.6 

[test]
name: rint float8
kernel_name: test_8_rint_float
global_size: 9 0 0

arg_out: 0 buffer float[72] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[72] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 -0.6 -0.6 -0.6 -0.6 -0.6 -0.6 -0.6 -0.6 nan nan nan nan nan nan nan nan -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 

[test]
name: rint float16
kernel_name: test_16_rint_float
global_size: 9 0 0

arg_out: 0 buffer float[144] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[144] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 -0.6 -0.6 -0.6 -0.6 -0.6 -0.6 -0.6 -0.6 -0.6 -0.6 -0.6 -0.6 -0.6 -0.6 -0.6 -0.6 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 

!*/

kernel void test_1_rint_float(global float* out, global float* in0){
  out[get_global_id(0)] = rint(in0[get_global_id(0)]);
}

kernel void test_2_rint_float(global float* out, global float* in0){
  vstore2(rint(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_rint_float(global float* out, global float* in0){
  vstore4(rint(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_rint_float(global float* out, global float* in0){
  vstore8(rint(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_rint_float(global float* out, global float* in0){
  vstore16(rint(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

