/*!
[config]
name: Test float remquo built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: remquo_private float1
kernel_name: test_1_remquo_private_float
global_size: 8 0 0

arg_out: 0 buffer float[8] -0.9000000953674316 0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.0 -0.0 5.1 nan  tolerance 0 ulp
arg_out: 1 buffer int[8] 2 -2 -2 2 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[8] 5.1 -5.1 5.1 -5.1 0.0 -0.0 5.1 5.1 
arg_in: 3 buffer float[8] 3.0 3.0 -3.0 -3.0 1.0 1.0 inf 0.0 

[test]
name: remquo_local float1
kernel_name: test_1_remquo_local_float
global_size: 8 0 0

arg_out: 0 buffer float[8] -0.9000000953674316 0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.0 -0.0 5.1 nan  tolerance 0 ulp
arg_out: 1 buffer int[8] 2 -2 -2 2 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[8] 5.1 -5.1 5.1 -5.1 0.0 -0.0 5.1 5.1 
arg_in: 3 buffer float[8] 3.0 3.0 -3.0 -3.0 1.0 1.0 inf 0.0 

[test]
name: remquo_global float1
kernel_name: test_1_remquo_global_float
global_size: 8 0 0

arg_out: 0 buffer float[8] -0.9000000953674316 0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.0 -0.0 5.1 nan  tolerance 0 ulp
arg_out: 1 buffer int[8] 2 -2 -2 2 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[8] 5.1 -5.1 5.1 -5.1 0.0 -0.0 5.1 5.1 
arg_in: 3 buffer float[8] 3.0 3.0 -3.0 -3.0 1.0 1.0 inf 0.0 

[test]
name: remquo_private float2
kernel_name: test_2_remquo_private_float
global_size: 8 0 0

arg_out: 0 buffer float[16] -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 -0.0 -0.0 5.1 5.1 nan nan  tolerance 0 ulp
arg_out: 1 buffer int[16] 2 2 -2 -2 -2 -2 2 2 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[16] 5.1 5.1 -5.1 -5.1 5.1 5.1 -5.1 -5.1 0.0 0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 
arg_in: 3 buffer float[16] 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 inf inf 0.0 0.0 

[test]
name: remquo_local float2
kernel_name: test_2_remquo_local_float
global_size: 8 0 0

arg_out: 0 buffer float[16] -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 -0.0 -0.0 5.1 5.1 nan nan  tolerance 0 ulp
arg_out: 1 buffer int[16] 2 2 -2 -2 -2 -2 2 2 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[16] 5.1 5.1 -5.1 -5.1 5.1 5.1 -5.1 -5.1 0.0 0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 
arg_in: 3 buffer float[16] 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 inf inf 0.0 0.0 

[test]
name: remquo_global float2
kernel_name: test_2_remquo_global_float
global_size: 8 0 0

arg_out: 0 buffer float[16] -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 -0.0 -0.0 5.1 5.1 nan nan  tolerance 0 ulp
arg_out: 1 buffer int[16] 2 2 -2 -2 -2 -2 2 2 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[16] 5.1 5.1 -5.1 -5.1 5.1 5.1 -5.1 -5.1 0.0 0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 
arg_in: 3 buffer float[16] 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 inf inf 0.0 0.0 

[test]
name: remquo_private float4
kernel_name: test_4_remquo_private_float
global_size: 8 0 0

arg_out: 0 buffer float[32] -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer int[32] 2 2 2 2 -2 -2 -2 -2 -2 -2 -2 -2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[32] 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 
arg_in: 3 buffer float[32] 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf 0.0 0.0 0.0 0.0 

[test]
name: remquo_local float4
kernel_name: test_4_remquo_local_float
global_size: 8 0 0

arg_out: 0 buffer float[32] -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer int[32] 2 2 2 2 -2 -2 -2 -2 -2 -2 -2 -2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[32] 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 
arg_in: 3 buffer float[32] 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf 0.0 0.0 0.0 0.0 

[test]
name: remquo_global float4
kernel_name: test_4_remquo_global_float
global_size: 8 0 0

arg_out: 0 buffer float[32] -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer int[32] 2 2 2 2 -2 -2 -2 -2 -2 -2 -2 -2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[32] 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 
arg_in: 3 buffer float[32] 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf 0.0 0.0 0.0 0.0 

[test]
name: remquo_private float8
kernel_name: test_8_remquo_private_float
global_size: 8 0 0

arg_out: 0 buffer float[64] -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer int[64] 2 2 2 2 2 2 2 2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[64] 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 
arg_in: 3 buffer float[64] 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

[test]
name: remquo_local float8
kernel_name: test_8_remquo_local_float
global_size: 8 0 0

arg_out: 0 buffer float[64] -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer int[64] 2 2 2 2 2 2 2 2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[64] 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 
arg_in: 3 buffer float[64] 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

[test]
name: remquo_global float8
kernel_name: test_8_remquo_global_float
global_size: 8 0 0

arg_out: 0 buffer float[64] -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer int[64] 2 2 2 2 2 2 2 2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[64] 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 
arg_in: 3 buffer float[64] 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

[test]
name: remquo_private float16
kernel_name: test_16_remquo_private_float
global_size: 8 0 0

arg_out: 0 buffer float[128] -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer int[128] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[128] 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 
arg_in: 3 buffer float[128] 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

[test]
name: remquo_local float16
kernel_name: test_16_remquo_local_float
global_size: 8 0 0

arg_out: 0 buffer float[128] -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer int[128] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[128] 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 
arg_in: 3 buffer float[128] 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

[test]
name: remquo_global float16
kernel_name: test_16_remquo_global_float
global_size: 8 0 0

arg_out: 0 buffer float[128] -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer int[128] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[128] 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 
arg_in: 3 buffer float[128] 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

!*/

kernel void test_1_remquo_private_float(global float* out, global int* out1, global float* in0, global float* in1){
  private int tmp1;
  out[get_global_id(0)] = remquo(in0[get_global_id(0)], in1[get_global_id(0)], &tmp1);
  out1[get_global_id(0)] = tmp1;
}

kernel void test_2_remquo_private_float(global float* out, global int* out1, global float* in0, global float* in1){
  private int2 tmp1;
  vstore2(remquo(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), &tmp1), get_global_id(0), out);
  vstore2(tmp1, get_global_id(0), out1);
}

kernel void test_4_remquo_private_float(global float* out, global int* out1, global float* in0, global float* in1){
  private int4 tmp1;
  vstore4(remquo(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), &tmp1), get_global_id(0), out);
  vstore4(tmp1, get_global_id(0), out1);
}

kernel void test_8_remquo_private_float(global float* out, global int* out1, global float* in0, global float* in1){
  private int8 tmp1;
  vstore8(remquo(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), &tmp1), get_global_id(0), out);
  vstore8(tmp1, get_global_id(0), out1);
}

kernel void test_16_remquo_private_float(global float* out, global int* out1, global float* in0, global float* in1){
  private int16 tmp1;
  vstore16(remquo(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), &tmp1), get_global_id(0), out);
  vstore16(tmp1, get_global_id(0), out1);
}

kernel void test_1_remquo_local_float(global float* out, global int* out1, global float* in0, global float* in1){
  local int tmp1;
  out[get_global_id(0)] = remquo(in0[get_global_id(0)], in1[get_global_id(0)], &tmp1);
  out1[get_global_id(0)] = tmp1;
}

kernel void test_2_remquo_local_float(global float* out, global int* out1, global float* in0, global float* in1){
  local int2 tmp1;
  vstore2(remquo(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), &tmp1), get_global_id(0), out);
  vstore2(tmp1, get_global_id(0), out1);
}

kernel void test_4_remquo_local_float(global float* out, global int* out1, global float* in0, global float* in1){
  local int4 tmp1;
  vstore4(remquo(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), &tmp1), get_global_id(0), out);
  vstore4(tmp1, get_global_id(0), out1);
}

kernel void test_8_remquo_local_float(global float* out, global int* out1, global float* in0, global float* in1){
  local int8 tmp1;
  vstore8(remquo(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), &tmp1), get_global_id(0), out);
  vstore8(tmp1, get_global_id(0), out1);
}

kernel void test_16_remquo_local_float(global float* out, global int* out1, global float* in0, global float* in1){
  local int16 tmp1;
  vstore16(remquo(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), &tmp1), get_global_id(0), out);
  vstore16(tmp1, get_global_id(0), out1);
}

kernel void test_1_remquo_global_float(global float* out, global int* out1, global float* in0, global float* in1){
  global int *tmp1 = out1;
  out[get_global_id(0)] = remquo(in0[get_global_id(0)], in1[get_global_id(0)], &tmp1[get_global_id(0)]);
}

kernel void test_2_remquo_global_float(global float* out, global int* out1, global float* in0, global float* in1){
  global int2 *tmp1 = out1;
  vstore2(remquo(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_4_remquo_global_float(global float* out, global int* out1, global float* in0, global float* in1){
  global int4 *tmp1 = out1;
  vstore4(remquo(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_8_remquo_global_float(global float* out, global int* out1, global float* in0, global float* in1){
  global int8 *tmp1 = out1;
  vstore8(remquo(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_16_remquo_global_float(global float* out, global int* out1, global float* in0, global float* in1){
  global int16 *tmp1 = out1;
  vstore16(remquo(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

