/*!
[config]
name: Test float remainder built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: remainder float1
kernel_name: test_1_remainder_float
global_size: 8 0 0

arg_out: 0 buffer float[8] -0.9000000953674316 0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.0 -0.0 5.1 nan  tolerance 0 ulp
arg_in: 1 buffer float[8] 5.1 -5.1 5.1 -5.1 0.0 -0.0 5.1 5.1 
arg_in: 2 buffer float[8] 3.0 3.0 -3.0 -3.0 1.0 1.0 inf 0.0 

[test]
name: remainder float2
kernel_name: test_2_remainder_float
global_size: 8 0 0

arg_out: 0 buffer float[16] -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 -0.0 -0.0 5.1 5.1 nan nan  tolerance 0 ulp
arg_in: 1 buffer float[16] 5.1 5.1 -5.1 -5.1 5.1 5.1 -5.1 -5.1 0.0 0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 
arg_in: 2 buffer float[16] 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 inf inf 0.0 0.0 

[test]
name: remainder float4
kernel_name: test_4_remainder_float
global_size: 8 0 0

arg_out: 0 buffer float[32] -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[32] 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 
arg_in: 2 buffer float[32] 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf 0.0 0.0 0.0 0.0 

[test]
name: remainder float8
kernel_name: test_8_remainder_float
global_size: 8 0 0

arg_out: 0 buffer float[64] -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[64] 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 
arg_in: 2 buffer float[64] 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

[test]
name: remainder float16
kernel_name: test_16_remainder_float
global_size: 8 0 0

arg_out: 0 buffer float[128] -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 -0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.9000000953674316 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[128] 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 -5.1 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 
arg_in: 2 buffer float[128] 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

!*/

kernel void test_1_remainder_float(global float* out, global float* in0, global float* in1){
  out[get_global_id(0)] = remainder(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_remainder_float(global float* out, global float* in0, global float* in1){
  vstore2(remainder(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_remainder_float(global float* out, global float* in0, global float* in1){
  vstore4(remainder(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_remainder_float(global float* out, global float* in0, global float* in1){
  vstore8(remainder(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_remainder_float(global float* out, global float* in0, global float* in1){
  vstore16(remainder(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

