/*!
[config]
name: Test float pown built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: pown float1
kernel_name: test_1_pown_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 1.0 1000.0 0.008432264881050257 8.187505353567209e+30 -1.0 -inf  tolerance 16 ulp
arg_in: 1 buffer float[6] 1.0 10.0 -3.3 1234 -1.0 -inf 
arg_in: 2 buffer int[6] 0 3 -4 10 2147483647 2147483647 

[test]
name: pown float2
kernel_name: test_2_pown_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 1.0 1.0 1000.0 1000.0 0.008432264881050257 0.008432264881050257 8.187505353567209e+30 8.187505353567209e+30 -1.0 -1.0 -inf -inf  tolerance 16 ulp
arg_in: 1 buffer float[12] 1.0 1.0 10.0 10.0 -3.3 -3.3 1234 1234 -1.0 -1.0 -inf -inf 
arg_in: 2 buffer int[12] 0 0 3 3 -4 -4 10 10 2147483647 2147483647 2147483647 2147483647 

[test]
name: pown float4
kernel_name: test_4_pown_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 1.0 1.0 1.0 1.0 1000.0 1000.0 1000.0 1000.0 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf  tolerance 16 ulp
arg_in: 1 buffer float[24] 1.0 1.0 1.0 1.0 10.0 10.0 10.0 10.0 -3.3 -3.3 -3.3 -3.3 1234 1234 1234 1234 -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf 
arg_in: 2 buffer int[24] 0 0 0 0 3 3 3 3 -4 -4 -4 -4 10 10 10 10 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 

[test]
name: pown float8
kernel_name: test_8_pown_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1000.0 1000.0 1000.0 1000.0 1000.0 1000.0 1000.0 1000.0 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf -inf -inf -inf -inf  tolerance 16 ulp
arg_in: 1 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 -3.3 -3.3 -3.3 -3.3 -3.3 -3.3 -3.3 -3.3 1234 1234 1234 1234 1234 1234 1234 1234 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf -inf -inf -inf -inf 
arg_in: 2 buffer int[48] 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 -4 -4 -4 -4 -4 -4 -4 -4 10 10 10 10 10 10 10 10 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 

[test]
name: pown float16
kernel_name: test_16_pown_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1000.0 1000.0 1000.0 1000.0 1000.0 1000.0 1000.0 1000.0 1000.0 1000.0 1000.0 1000.0 1000.0 1000.0 1000.0 1000.0 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 0.008432264881050257 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 8.187505353567209e+30 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf  tolerance 16 ulp
arg_in: 1 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 -3.3 -3.3 -3.3 -3.3 -3.3 -3.3 -3.3 -3.3 -3.3 -3.3 -3.3 -3.3 -3.3 -3.3 -3.3 -3.3 1234 1234 1234 1234 1234 1234 1234 1234 1234 1234 1234 1234 1234 1234 1234 1234 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 
arg_in: 2 buffer int[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 

!*/

kernel void test_1_pown_float(global float* out, global float* in0, global int* in1){
  out[get_global_id(0)] = pown(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_pown_float(global float* out, global float* in0, global int* in1){
  vstore2(pown(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_pown_float(global float* out, global float* in0, global int* in1){
  vstore4(pown(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_pown_float(global float* out, global float* in0, global int* in1){
  vstore8(pown(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_pown_float(global float* out, global float* in0, global int* in1){
  vstore16(pown(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

