/*!
[config]
name: Test float pow built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: pow float1
kernel_name: test_1_pow_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 0.0 59049.0 -0.0007513148009015778 8.220740564632747e+30 4.656612875245797e-10 inf  tolerance 16 ulp
arg_in: 1 buffer float[6] 0 -3 -11 1234.5 2147483647 2147483647 
arg_in: 2 buffer float[6] 1.0 10.0 -3.0 10 -1.0 -inf 

[test]
name: pow float2
kernel_name: test_2_pow_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0.0 0.0 59049.0 59049.0 -0.0007513148009015778 -0.0007513148009015778 8.220740564632747e+30 8.220740564632747e+30 4.656612875245797e-10 4.656612875245797e-10 inf inf  tolerance 16 ulp
arg_in: 1 buffer float[12] 0 0 -3 -3 -11 -11 1234.5 1234.5 2147483647 2147483647 2147483647 2147483647 
arg_in: 2 buffer float[12] 1.0 1.0 10.0 10.0 -3.0 -3.0 10 10 -1.0 -1.0 -inf -inf 

[test]
name: pow float4
kernel_name: test_4_pow_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 59049.0 59049.0 59049.0 59049.0 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 inf inf inf inf  tolerance 16 ulp
arg_in: 1 buffer float[24] 0 0 0 0 -3 -3 -3 -3 -11 -11 -11 -11 1234.5 1234.5 1234.5 1234.5 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 
arg_in: 2 buffer float[24] 1.0 1.0 1.0 1.0 10.0 10.0 10.0 10.0 -3.0 -3.0 -3.0 -3.0 10 10 10 10 -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf 

[test]
name: pow float8
kernel_name: test_8_pow_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 59049.0 59049.0 59049.0 59049.0 59049.0 59049.0 59049.0 59049.0 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 inf inf inf inf inf inf inf inf  tolerance 16 ulp
arg_in: 1 buffer float[48] 0 0 0 0 0 0 0 0 -3 -3 -3 -3 -3 -3 -3 -3 -11 -11 -11 -11 -11 -11 -11 -11 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 
arg_in: 2 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 10 10 10 10 10 10 10 10 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf -inf -inf -inf -inf 

[test]
name: pow float16
kernel_name: test_16_pow_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 59049.0 59049.0 59049.0 59049.0 59049.0 59049.0 59049.0 59049.0 59049.0 59049.0 59049.0 59049.0 59049.0 59049.0 59049.0 59049.0 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 -0.0007513148009015778 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 8.220740564632747e+30 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 4.656612875245797e-10 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf  tolerance 16 ulp
arg_in: 1 buffer float[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 
arg_in: 2 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 

!*/

kernel void test_1_pow_float(global float* out, global float* in0, global float* in1){
  out[get_global_id(0)] = pow(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_pow_float(global float* out, global float* in0, global float* in1){
  vstore2(pow(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_pow_float(global float* out, global float* in0, global float* in1){
  vstore4(pow(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_pow_float(global float* out, global float* in0, global float* in1){
  vstore8(pow(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_pow_float(global float* out, global float* in0, global float* in1){
  vstore16(pow(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

