/*!
[config]
name: Test float nextafter built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: nextafter float1
kernel_name: test_1_nextafter_float
global_size: 7 0 0

arg_out: 0 buffer float[7] 1.401298e-45 -1.401298e-45 1.0000001192092896 0.9999999403953552 nan nan 5.0  tolerance 0 ulp
arg_in: 1 buffer float[7] 0.0 0.0 1.0 1.0 nan 2.5 5.0 
arg_in: 2 buffer float[7] 1.0 -1.0 2.0 0.0 3.4 nan 5.0 

[test]
name: nextafter float2
kernel_name: test_2_nextafter_float
global_size: 7 0 0

arg_out: 0 buffer float[14] 1.401298e-45 1.401298e-45 -1.401298e-45 -1.401298e-45 1.0000001192092896 1.0000001192092896 0.9999999403953552 0.9999999403953552 nan nan nan nan 5.0 5.0  tolerance 0 ulp
arg_in: 1 buffer float[14] 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 nan nan 2.5 2.5 5.0 5.0 
arg_in: 2 buffer float[14] 1.0 1.0 -1.0 -1.0 2.0 2.0 0.0 0.0 3.4 3.4 nan nan 5.0 5.0 

[test]
name: nextafter float4
kernel_name: test_4_nextafter_float
global_size: 7 0 0

arg_out: 0 buffer float[28] 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 nan nan nan nan nan nan nan nan 5.0 5.0 5.0 5.0  tolerance 0 ulp
arg_in: 1 buffer float[28] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan 2.5 2.5 2.5 2.5 5.0 5.0 5.0 5.0 
arg_in: 2 buffer float[28] 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 2.0 2.0 2.0 2.0 0.0 0.0 0.0 0.0 3.4 3.4 3.4 3.4 nan nan nan nan 5.0 5.0 5.0 5.0 

[test]
name: nextafter float8
kernel_name: test_8_nextafter_float
global_size: 7 0 0

arg_out: 0 buffer float[56] 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0  tolerance 0 ulp
arg_in: 1 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 
arg_in: 2 buffer float[56] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 3.4 3.4 3.4 3.4 3.4 3.4 3.4 3.4 nan nan nan nan nan nan nan nan 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 

[test]
name: nextafter float16
kernel_name: test_16_nextafter_float
global_size: 7 0 0

arg_out: 0 buffer float[112] 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 -1.401298e-45 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 1.0000001192092896 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0  tolerance 0 ulp
arg_in: 1 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 2.5 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 
arg_in: 2 buffer float[112] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 3.4 3.4 3.4 3.4 3.4 3.4 3.4 3.4 3.4 3.4 3.4 3.4 3.4 3.4 3.4 3.4 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 

!*/

kernel void test_1_nextafter_float(global float* out, global float* in0, global float* in1){
  out[get_global_id(0)] = nextafter(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_nextafter_float(global float* out, global float* in0, global float* in1){
  vstore2(nextafter(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_nextafter_float(global float* out, global float* in0, global float* in1){
  vstore4(nextafter(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_nextafter_float(global float* out, global float* in0, global float* in1){
  vstore8(nextafter(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_nextafter_float(global float* out, global float* in0, global float* in1){
  vstore16(nextafter(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

