/*!
[config]
name: Test float modf built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: modf_private float1
kernel_name: test_1_modf_private_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 0.0 0.5 0.25 0.0 1e-15 nan  tolerance 0 ulp
arg_out: 1 buffer float[6] 1 1.0 0.0 0.0 0.0 nan  tolerance 0 ulp
arg_in: 2 buffer float[6] 1.0 1.5 0.25 0.0 1e-15 nan 

[test]
name: modf_local float1
kernel_name: test_1_modf_local_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 0.0 0.5 0.25 0.0 1e-15 nan  tolerance 0 ulp
arg_out: 1 buffer float[6] 1 1.0 0.0 0.0 0.0 nan  tolerance 0 ulp
arg_in: 2 buffer float[6] 1.0 1.5 0.25 0.0 1e-15 nan 

[test]
name: modf_global float1
kernel_name: test_1_modf_global_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 0.0 0.5 0.25 0.0 1e-15 nan  tolerance 0 ulp
arg_out: 1 buffer float[6] 1 1.0 0.0 0.0 0.0 nan  tolerance 0 ulp
arg_in: 2 buffer float[6] 1.0 1.5 0.25 0.0 1e-15 nan 

[test]
name: modf_private float2
kernel_name: test_2_modf_private_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0.0 0.0 0.5 0.5 0.25 0.25 0.0 0.0 1e-15 1e-15 nan nan  tolerance 0 ulp
arg_out: 1 buffer float[12] 1 1 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan  tolerance 0 ulp
arg_in: 2 buffer float[12] 1.0 1.0 1.5 1.5 0.25 0.25 0.0 0.0 1e-15 1e-15 nan nan 

[test]
name: modf_local float2
kernel_name: test_2_modf_local_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0.0 0.0 0.5 0.5 0.25 0.25 0.0 0.0 1e-15 1e-15 nan nan  tolerance 0 ulp
arg_out: 1 buffer float[12] 1 1 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan  tolerance 0 ulp
arg_in: 2 buffer float[12] 1.0 1.0 1.5 1.5 0.25 0.25 0.0 0.0 1e-15 1e-15 nan nan 

[test]
name: modf_global float2
kernel_name: test_2_modf_global_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0.0 0.0 0.5 0.5 0.25 0.25 0.0 0.0 1e-15 1e-15 nan nan  tolerance 0 ulp
arg_out: 1 buffer float[12] 1 1 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan  tolerance 0 ulp
arg_in: 2 buffer float[12] 1.0 1.0 1.5 1.5 0.25 0.25 0.0 0.0 1e-15 1e-15 nan nan 

[test]
name: modf_private float4
kernel_name: test_4_modf_private_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer float[24] 1 1 1 1 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan  tolerance 0 ulp
arg_in: 2 buffer float[24] 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan 

[test]
name: modf_local float4
kernel_name: test_4_modf_local_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer float[24] 1 1 1 1 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan  tolerance 0 ulp
arg_in: 2 buffer float[24] 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan 

[test]
name: modf_global float4
kernel_name: test_4_modf_global_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer float[24] 1 1 1 1 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan  tolerance 0 ulp
arg_in: 2 buffer float[24] 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan 

[test]
name: modf_private float8
kernel_name: test_8_modf_private_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer float[48] 1 1 1 1 1 1 1 1 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 2 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan 

[test]
name: modf_local float8
kernel_name: test_8_modf_local_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer float[48] 1 1 1 1 1 1 1 1 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 2 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan 

[test]
name: modf_global float8
kernel_name: test_8_modf_global_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer float[48] 1 1 1 1 1 1 1 1 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 2 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan 

[test]
name: modf_private float16
kernel_name: test_16_modf_private_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer float[96] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 2 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

[test]
name: modf_local float16
kernel_name: test_16_modf_local_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer float[96] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 2 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

[test]
name: modf_global float16
kernel_name: test_16_modf_global_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_out: 1 buffer float[96] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 2 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_modf_private_float(global float* out, global float* out1, global float* in0){
  private float tmp1;
  out[get_global_id(0)] = modf(in0[get_global_id(0)], &tmp1);
  out1[get_global_id(0)] = tmp1;
}

kernel void test_2_modf_private_float(global float* out, global float* out1, global float* in0){
  private float2 tmp1;
  vstore2(modf(vload2(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore2(tmp1, get_global_id(0), out1);
}

kernel void test_4_modf_private_float(global float* out, global float* out1, global float* in0){
  private float4 tmp1;
  vstore4(modf(vload4(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore4(tmp1, get_global_id(0), out1);
}

kernel void test_8_modf_private_float(global float* out, global float* out1, global float* in0){
  private float8 tmp1;
  vstore8(modf(vload8(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore8(tmp1, get_global_id(0), out1);
}

kernel void test_16_modf_private_float(global float* out, global float* out1, global float* in0){
  private float16 tmp1;
  vstore16(modf(vload16(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore16(tmp1, get_global_id(0), out1);
}

kernel void test_1_modf_local_float(global float* out, global float* out1, global float* in0){
  local float tmp1;
  out[get_global_id(0)] = modf(in0[get_global_id(0)], &tmp1);
  out1[get_global_id(0)] = tmp1;
}

kernel void test_2_modf_local_float(global float* out, global float* out1, global float* in0){
  local float2 tmp1;
  vstore2(modf(vload2(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore2(tmp1, get_global_id(0), out1);
}

kernel void test_4_modf_local_float(global float* out, global float* out1, global float* in0){
  local float4 tmp1;
  vstore4(modf(vload4(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore4(tmp1, get_global_id(0), out1);
}

kernel void test_8_modf_local_float(global float* out, global float* out1, global float* in0){
  local float8 tmp1;
  vstore8(modf(vload8(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore8(tmp1, get_global_id(0), out1);
}

kernel void test_16_modf_local_float(global float* out, global float* out1, global float* in0){
  local float16 tmp1;
  vstore16(modf(vload16(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore16(tmp1, get_global_id(0), out1);
}

kernel void test_1_modf_global_float(global float* out, global float* out1, global float* in0){
  global float *tmp1 = out1;
  out[get_global_id(0)] = modf(in0[get_global_id(0)], &tmp1[get_global_id(0)]);
}

kernel void test_2_modf_global_float(global float* out, global float* out1, global float* in0){
  global float2 *tmp1 = out1;
  vstore2(modf(vload2(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_4_modf_global_float(global float* out, global float* out1, global float* in0){
  global float4 *tmp1 = out1;
  vstore4(modf(vload4(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_8_modf_global_float(global float* out, global float* out1, global float* in0){
  global float8 *tmp1 = out1;
  vstore8(modf(vload8(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_16_modf_global_float(global float* out, global float* out1, global float* in0){
  global float16 *tmp1 = out1;
  vstore16(modf(vload16(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

