/*!
[config]
name: Test float minmag built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: minmag float1
kernel_name: test_1_minmag_float
global_size: 7 0 0

arg_out: 0 buffer float[7] 0.0 -0.5 0.0 1.0 1.0 1.0 nan  tolerance 0 ulp
arg_in: 1 buffer float[7] 1.0 -0.5 1.0 1.0 1.0 nan nan 
arg_in: 2 buffer float[7] 0.0 1.0 0.0 -1.5 nan 1.0 nan 

[test]
name: minmag float2
kernel_name: test_2_minmag_float
global_size: 7 0 0

arg_out: 0 buffer float[14] 0.0 0.0 -0.5 -0.5 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan  tolerance 0 ulp
arg_in: 1 buffer float[14] 1.0 1.0 -0.5 -0.5 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan 
arg_in: 2 buffer float[14] 0.0 0.0 1.0 1.0 0.0 0.0 -1.5 -1.5 nan nan 1.0 1.0 nan nan 

[test]
name: minmag float4
kernel_name: test_4_minmag_float
global_size: 7 0 0

arg_out: 0 buffer float[28] 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[28] 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[28] 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 -1.5 -1.5 -1.5 -1.5 nan nan nan nan 1.0 1.0 1.0 1.0 nan nan nan nan 

[test]
name: minmag float8
kernel_name: test_8_minmag_float
global_size: 7 0 0

arg_out: 0 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[56] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -1.5 -1.5 -1.5 -1.5 -1.5 -1.5 -1.5 -1.5 nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan 

[test]
name: minmag float16
kernel_name: test_16_minmag_float
global_size: 7 0 0

arg_out: 0 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[112] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -1.5 -1.5 -1.5 -1.5 -1.5 -1.5 -1.5 -1.5 -1.5 -1.5 -1.5 -1.5 -1.5 -1.5 -1.5 -1.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_minmag_float(global float* out, global float* in0, global float* in1){
  out[get_global_id(0)] = minmag(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_minmag_float(global float* out, global float* in0, global float* in1){
  vstore2(minmag(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_minmag_float(global float* out, global float* in0, global float* in1){
  vstore4(minmag(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_minmag_float(global float* out, global float* in0, global float* in1){
  vstore8(minmag(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_minmag_float(global float* out, global float* in0, global float* in1){
  vstore16(minmag(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

