/*!
[config]
name: Test float logb built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: logb float1
kernel_name: test_1_logb_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 0 3 1 10 inf inf  tolerance 0 ulp
arg_in: 1 buffer float[6] 1.0 10.0 -3.0 1234.5 inf -inf 

[test]
name: logb float2
kernel_name: test_2_logb_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0 0 3 3 1 1 10 10 inf inf inf inf  tolerance 0 ulp
arg_in: 1 buffer float[12] 1.0 1.0 10.0 10.0 -3.0 -3.0 1234.5 1234.5 inf inf -inf -inf 

[test]
name: logb float4
kernel_name: test_4_logb_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0 0 0 0 3 3 3 3 1 1 1 1 10 10 10 10 inf inf inf inf inf inf inf inf  tolerance 0 ulp
arg_in: 1 buffer float[24] 1.0 1.0 1.0 1.0 10.0 10.0 10.0 10.0 -3.0 -3.0 -3.0 -3.0 1234.5 1234.5 1234.5 1234.5 inf inf inf inf -inf -inf -inf -inf 

[test]
name: logb float8
kernel_name: test_8_logb_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 1 1 1 1 1 1 1 1 10 10 10 10 10 10 10 10 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf  tolerance 0 ulp
arg_in: 1 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf 

[test]
name: logb float16
kernel_name: test_16_logb_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf  tolerance 0 ulp
arg_in: 1 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 

!*/

kernel void test_1_logb_float(global float* out, global float* in0){
  out[get_global_id(0)] = logb(in0[get_global_id(0)]);
}

kernel void test_2_logb_float(global float* out, global float* in0){
  vstore2(logb(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_logb_float(global float* out, global float* in0){
  vstore4(logb(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_logb_float(global float* out, global float* in0){
  vstore8(logb(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_logb_float(global float* out, global float* in0){
  vstore16(logb(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

