/*!
[config]
name: Test float log2 built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: log2 float1
kernel_name: test_1_log2_float
global_size: 4 0 0

arg_out: 0 buffer float[4] -1.0 -inf -49.82892142331043 nan  tolerance 3 ulp
arg_in: 1 buffer float[4] 0.5 0.0 1e-15 nan 

[test]
name: log2 float2
kernel_name: test_2_log2_float
global_size: 4 0 0

arg_out: 0 buffer float[8] -1.0 -1.0 -inf -inf -49.82892142331043 -49.82892142331043 nan nan  tolerance 3 ulp
arg_in: 1 buffer float[8] 0.5 0.5 0.0 0.0 1e-15 1e-15 nan nan 

[test]
name: log2 float4
kernel_name: test_4_log2_float
global_size: 4 0 0

arg_out: 0 buffer float[16] -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 nan nan nan nan  tolerance 3 ulp
arg_in: 1 buffer float[16] 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan 

[test]
name: log2 float8
kernel_name: test_8_log2_float
global_size: 4 0 0

arg_out: 0 buffer float[32] -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf -inf -inf -inf -inf -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 nan nan nan nan nan nan nan nan  tolerance 3 ulp
arg_in: 1 buffer float[32] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan 

[test]
name: log2 float16
kernel_name: test_16_log2_float
global_size: 4 0 0

arg_out: 0 buffer float[64] -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 -49.82892142331043 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 3 ulp
arg_in: 1 buffer float[64] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_log2_float(global float* out, global float* in0){
  out[get_global_id(0)] = log2(in0[get_global_id(0)]);
}

kernel void test_2_log2_float(global float* out, global float* in0){
  vstore2(log2(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_log2_float(global float* out, global float* in0){
  vstore4(log2(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_log2_float(global float* out, global float* in0){
  vstore8(log2(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_log2_float(global float* out, global float* in0){
  vstore16(log2(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

