/*!
[config]
name: Test float log1p built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: log1p float1
kernel_name: test_1_log1p_float
global_size: 4 0 0

arg_out: 0 buffer float[4] 0.4054651081081644 -inf 9.999999999999995e-16 nan  tolerance 2 ulp
arg_in: 1 buffer float[4] 0.5 -1.0 1e-15 nan 

[test]
name: log1p float2
kernel_name: test_2_log1p_float
global_size: 4 0 0

arg_out: 0 buffer float[8] 0.4054651081081644 0.4054651081081644 -inf -inf 9.999999999999995e-16 9.999999999999995e-16 nan nan  tolerance 2 ulp
arg_in: 1 buffer float[8] 0.5 0.5 -1.0 -1.0 1e-15 1e-15 nan nan 

[test]
name: log1p float4
kernel_name: test_4_log1p_float
global_size: 4 0 0

arg_out: 0 buffer float[16] 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 -inf -inf -inf -inf 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 nan nan nan nan  tolerance 2 ulp
arg_in: 1 buffer float[16] 0.5 0.5 0.5 0.5 -1.0 -1.0 -1.0 -1.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan 

[test]
name: log1p float8
kernel_name: test_8_log1p_float
global_size: 4 0 0

arg_out: 0 buffer float[32] 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 -inf -inf -inf -inf -inf -inf -inf -inf 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 nan nan nan nan nan nan nan nan  tolerance 2 ulp
arg_in: 1 buffer float[32] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan 

[test]
name: log1p float16
kernel_name: test_16_log1p_float
global_size: 4 0 0

arg_out: 0 buffer float[64] 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 0.4054651081081644 -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 9.999999999999995e-16 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 2 ulp
arg_in: 1 buffer float[64] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_log1p_float(global float* out, global float* in0){
  out[get_global_id(0)] = log1p(in0[get_global_id(0)]);
}

kernel void test_2_log1p_float(global float* out, global float* in0){
  vstore2(log1p(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_log1p_float(global float* out, global float* in0){
  vstore4(log1p(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_log1p_float(global float* out, global float* in0){
  vstore8(log1p(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_log1p_float(global float* out, global float* in0){
  vstore16(log1p(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

