/*!
[config]
name: Test float log10 built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: log10 float1
kernel_name: test_1_log10_float
global_size: 4 0 0

arg_out: 0 buffer float[4] -0.3010299956639812 -inf -15.0 nan  tolerance 3 ulp
arg_in: 1 buffer float[4] 0.5 0.0 1e-15 nan 

[test]
name: log10 float2
kernel_name: test_2_log10_float
global_size: 4 0 0

arg_out: 0 buffer float[8] -0.3010299956639812 -0.3010299956639812 -inf -inf -15.0 -15.0 nan nan  tolerance 3 ulp
arg_in: 1 buffer float[8] 0.5 0.5 0.0 0.0 1e-15 1e-15 nan nan 

[test]
name: log10 float4
kernel_name: test_4_log10_float
global_size: 4 0 0

arg_out: 0 buffer float[16] -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -inf -inf -inf -inf -15.0 -15.0 -15.0 -15.0 nan nan nan nan  tolerance 3 ulp
arg_in: 1 buffer float[16] 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan 

[test]
name: log10 float8
kernel_name: test_8_log10_float
global_size: 4 0 0

arg_out: 0 buffer float[32] -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -inf -inf -inf -inf -inf -inf -inf -inf -15.0 -15.0 -15.0 -15.0 -15.0 -15.0 -15.0 -15.0 nan nan nan nan nan nan nan nan  tolerance 3 ulp
arg_in: 1 buffer float[32] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan 

[test]
name: log10 float16
kernel_name: test_16_log10_float
global_size: 4 0 0

arg_out: 0 buffer float[64] -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -0.3010299956639812 -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -15.0 -15.0 -15.0 -15.0 -15.0 -15.0 -15.0 -15.0 -15.0 -15.0 -15.0 -15.0 -15.0 -15.0 -15.0 -15.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 3 ulp
arg_in: 1 buffer float[64] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_log10_float(global float* out, global float* in0){
  out[get_global_id(0)] = log10(in0[get_global_id(0)]);
}

kernel void test_2_log10_float(global float* out, global float* in0){
  vstore2(log10(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_log10_float(global float* out, global float* in0){
  vstore4(log10(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_log10_float(global float* out, global float* in0){
  vstore8(log10(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_log10_float(global float* out, global float* in0){
  vstore16(log10(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

