/*!
[config]
name: Test float log built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: log float1
kernel_name: test_1_log_float
global_size: 4 0 0

arg_out: 0 buffer float[4] -0.6931471805599453 -inf -34.538776394910684 nan  tolerance 3 ulp
arg_in: 1 buffer float[4] 0.5 0.0 1e-15 nan 

[test]
name: log float2
kernel_name: test_2_log_float
global_size: 4 0 0

arg_out: 0 buffer float[8] -0.6931471805599453 -0.6931471805599453 -inf -inf -34.538776394910684 -34.538776394910684 nan nan  tolerance 3 ulp
arg_in: 1 buffer float[8] 0.5 0.5 0.0 0.0 1e-15 1e-15 nan nan 

[test]
name: log float4
kernel_name: test_4_log_float
global_size: 4 0 0

arg_out: 0 buffer float[16] -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -inf -inf -inf -inf -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 nan nan nan nan  tolerance 3 ulp
arg_in: 1 buffer float[16] 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan 

[test]
name: log float8
kernel_name: test_8_log_float
global_size: 4 0 0

arg_out: 0 buffer float[32] -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -inf -inf -inf -inf -inf -inf -inf -inf -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 nan nan nan nan nan nan nan nan  tolerance 3 ulp
arg_in: 1 buffer float[32] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan 

[test]
name: log float16
kernel_name: test_16_log_float
global_size: 4 0 0

arg_out: 0 buffer float[64] -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -0.6931471805599453 -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 -34.538776394910684 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 3 ulp
arg_in: 1 buffer float[64] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_log_float(global float* out, global float* in0){
  out[get_global_id(0)] = log(in0[get_global_id(0)]);
}

kernel void test_2_log_float(global float* out, global float* in0){
  vstore2(log(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_log_float(global float* out, global float* in0){
  vstore4(log(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_log_float(global float* out, global float* in0){
  vstore8(log(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_log_float(global float* out, global float* in0){
  vstore16(log(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

