/*!
[config]
name: Test float lgamma_r built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: lgamma_r_private float1
kernel_name: test_1_lgamma_r_private_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 0.0 -0.12078223763524543 0.5723649429247004 nan 34.538776394910684 nan  tolerance 16777216 ulp
arg_out: 1 buffer int[6] 1 -1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[6] 1.0 1.5 0.5 0.0 1e-15 nan 

[test]
name: lgamma_r_local float1
kernel_name: test_1_lgamma_r_local_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 0.0 -0.12078223763524543 0.5723649429247004 nan 34.538776394910684 nan  tolerance 16777216 ulp
arg_out: 1 buffer int[6] 1 -1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[6] 1.0 1.5 0.5 0.0 1e-15 nan 

[test]
name: lgamma_r_global float1
kernel_name: test_1_lgamma_r_global_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 0.0 -0.12078223763524543 0.5723649429247004 nan 34.538776394910684 nan  tolerance 16777216 ulp
arg_out: 1 buffer int[6] 1 -1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[6] 1.0 1.5 0.5 0.0 1e-15 nan 

[test]
name: lgamma_r_private float2
kernel_name: test_2_lgamma_r_private_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0.0 0.0 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 nan nan 34.538776394910684 34.538776394910684 nan nan  tolerance 16777216 ulp
arg_out: 1 buffer int[12] 1 1 -1 -1 1 1 1 1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[12] 1.0 1.0 1.5 1.5 0.5 0.5 0.0 0.0 1e-15 1e-15 nan nan 

[test]
name: lgamma_r_local float2
kernel_name: test_2_lgamma_r_local_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0.0 0.0 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 nan nan 34.538776394910684 34.538776394910684 nan nan  tolerance 16777216 ulp
arg_out: 1 buffer int[12] 1 1 -1 -1 1 1 1 1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[12] 1.0 1.0 1.5 1.5 0.5 0.5 0.0 0.0 1e-15 1e-15 nan nan 

[test]
name: lgamma_r_global float2
kernel_name: test_2_lgamma_r_global_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0.0 0.0 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 nan nan 34.538776394910684 34.538776394910684 nan nan  tolerance 16777216 ulp
arg_out: 1 buffer int[12] 1 1 -1 -1 1 1 1 1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[12] 1.0 1.0 1.5 1.5 0.5 0.5 0.0 0.0 1e-15 1e-15 nan nan 

[test]
name: lgamma_r_private float4
kernel_name: test_4_lgamma_r_private_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 nan nan nan nan 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 nan nan nan nan  tolerance 16777216 ulp
arg_out: 1 buffer int[24] 1 1 1 1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[24] 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan 

[test]
name: lgamma_r_local float4
kernel_name: test_4_lgamma_r_local_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 nan nan nan nan 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 nan nan nan nan  tolerance 16777216 ulp
arg_out: 1 buffer int[24] 1 1 1 1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[24] 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan 

[test]
name: lgamma_r_global float4
kernel_name: test_4_lgamma_r_global_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 nan nan nan nan 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 nan nan nan nan  tolerance 16777216 ulp
arg_out: 1 buffer int[24] 1 1 1 1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[24] 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan 

[test]
name: lgamma_r_private float8
kernel_name: test_8_lgamma_r_private_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 nan nan nan nan nan nan nan nan 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 nan nan nan nan nan nan nan nan  tolerance 16777216 ulp
arg_out: 1 buffer int[48] 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan 

[test]
name: lgamma_r_local float8
kernel_name: test_8_lgamma_r_local_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 nan nan nan nan nan nan nan nan 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 nan nan nan nan nan nan nan nan  tolerance 16777216 ulp
arg_out: 1 buffer int[48] 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan 

[test]
name: lgamma_r_global float8
kernel_name: test_8_lgamma_r_global_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 nan nan nan nan nan nan nan nan 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 nan nan nan nan nan nan nan nan  tolerance 16777216 ulp
arg_out: 1 buffer int[48] 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan 

[test]
name: lgamma_r_private float16
kernel_name: test_16_lgamma_r_private_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 16777216 ulp
arg_out: 1 buffer int[96] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

[test]
name: lgamma_r_local float16
kernel_name: test_16_lgamma_r_local_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 16777216 ulp
arg_out: 1 buffer int[96] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

[test]
name: lgamma_r_global float16
kernel_name: test_16_lgamma_r_global_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 16777216 ulp
arg_out: 1 buffer int[96] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 16777216 
arg_in: 2 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_lgamma_r_private_float(global float* out, global int* out1, global float* in0){
  private int tmp1;
  out[get_global_id(0)] = lgamma_r(in0[get_global_id(0)], &tmp1);
  out1[get_global_id(0)] = tmp1;
}

kernel void test_2_lgamma_r_private_float(global float* out, global int* out1, global float* in0){
  private int2 tmp1;
  vstore2(lgamma_r(vload2(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore2(tmp1, get_global_id(0), out1);
}

kernel void test_4_lgamma_r_private_float(global float* out, global int* out1, global float* in0){
  private int4 tmp1;
  vstore4(lgamma_r(vload4(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore4(tmp1, get_global_id(0), out1);
}

kernel void test_8_lgamma_r_private_float(global float* out, global int* out1, global float* in0){
  private int8 tmp1;
  vstore8(lgamma_r(vload8(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore8(tmp1, get_global_id(0), out1);
}

kernel void test_16_lgamma_r_private_float(global float* out, global int* out1, global float* in0){
  private int16 tmp1;
  vstore16(lgamma_r(vload16(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore16(tmp1, get_global_id(0), out1);
}

kernel void test_1_lgamma_r_local_float(global float* out, global int* out1, global float* in0){
  local int tmp1;
  out[get_global_id(0)] = lgamma_r(in0[get_global_id(0)], &tmp1);
  out1[get_global_id(0)] = tmp1;
}

kernel void test_2_lgamma_r_local_float(global float* out, global int* out1, global float* in0){
  local int2 tmp1;
  vstore2(lgamma_r(vload2(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore2(tmp1, get_global_id(0), out1);
}

kernel void test_4_lgamma_r_local_float(global float* out, global int* out1, global float* in0){
  local int4 tmp1;
  vstore4(lgamma_r(vload4(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore4(tmp1, get_global_id(0), out1);
}

kernel void test_8_lgamma_r_local_float(global float* out, global int* out1, global float* in0){
  local int8 tmp1;
  vstore8(lgamma_r(vload8(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore8(tmp1, get_global_id(0), out1);
}

kernel void test_16_lgamma_r_local_float(global float* out, global int* out1, global float* in0){
  local int16 tmp1;
  vstore16(lgamma_r(vload16(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore16(tmp1, get_global_id(0), out1);
}

kernel void test_1_lgamma_r_global_float(global float* out, global int* out1, global float* in0){
  global int *tmp1 = out1;
  out[get_global_id(0)] = lgamma_r(in0[get_global_id(0)], &tmp1[get_global_id(0)]);
}

kernel void test_2_lgamma_r_global_float(global float* out, global int* out1, global float* in0){
  global int2 *tmp1 = out1;
  vstore2(lgamma_r(vload2(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_4_lgamma_r_global_float(global float* out, global int* out1, global float* in0){
  global int4 *tmp1 = out1;
  vstore4(lgamma_r(vload4(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_8_lgamma_r_global_float(global float* out, global int* out1, global float* in0){
  global int8 *tmp1 = out1;
  vstore8(lgamma_r(vload8(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_16_lgamma_r_global_float(global float* out, global int* out1, global float* in0){
  global int16 *tmp1 = out1;
  vstore16(lgamma_r(vload16(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

