/*!
[config]
name: Test float lgamma built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: lgamma float1
kernel_name: test_1_lgamma_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 0.0 -0.12078223763524543 0.5723649429247004 nan 34.538776394910684 nan  tolerance 16777216 ulp
arg_in: 1 buffer float[6] 1.0 1.5 0.5 0.0 1e-15 nan 

[test]
name: lgamma float2
kernel_name: test_2_lgamma_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0.0 0.0 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 nan nan 34.538776394910684 34.538776394910684 nan nan  tolerance 16777216 ulp
arg_in: 1 buffer float[12] 1.0 1.0 1.5 1.5 0.5 0.5 0.0 0.0 1e-15 1e-15 nan nan 

[test]
name: lgamma float4
kernel_name: test_4_lgamma_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 nan nan nan nan 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 nan nan nan nan  tolerance 16777216 ulp
arg_in: 1 buffer float[24] 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan 

[test]
name: lgamma float8
kernel_name: test_8_lgamma_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 nan nan nan nan nan nan nan nan 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 nan nan nan nan nan nan nan nan  tolerance 16777216 ulp
arg_in: 1 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan 

[test]
name: lgamma float16
kernel_name: test_16_lgamma_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 -0.12078223763524543 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 0.5723649429247004 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 34.538776394910684 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 16777216 ulp
arg_in: 1 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_lgamma_float(global float* out, global float* in0){
  out[get_global_id(0)] = lgamma(in0[get_global_id(0)]);
}

kernel void test_2_lgamma_float(global float* out, global float* in0){
  vstore2(lgamma(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_lgamma_float(global float* out, global float* in0){
  vstore4(lgamma(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_lgamma_float(global float* out, global float* in0){
  vstore8(lgamma(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_lgamma_float(global float* out, global float* in0){
  vstore16(lgamma(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

