/*!
[config]
name: Test float ldexp built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: ldexp float1
kernel_name: test_1_ldexp_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 0.0 4.0 15.2 1.75 nan inf  tolerance 0 ulp
arg_in: 1 buffer float[6] 0.0 1.0 0.95 3.5 nan 1.12312312 
arg_in: 2 buffer int[6] 0 2 4 -1 1 2031231231 

[test]
name: ldexp float2
kernel_name: test_2_ldexp_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0.0 0.0 4.0 4.0 15.2 15.2 1.75 1.75 nan nan inf inf  tolerance 0 ulp
arg_in: 1 buffer float[12] 0.0 0.0 1.0 1.0 0.95 0.95 3.5 3.5 nan nan 1.12312312 1.12312312 
arg_in: 2 buffer int[12] 0 0 2 2 4 4 -1 -1 1 1 2031231231 2031231231 

[test]
name: tss_ldexp float2
kernel_name: test_tss_2_ldexp_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0.0 0.0 4.0 4.0 15.2 15.2 1.75 1.75 nan nan inf inf  tolerance 0 ulp
arg_in: 1 buffer float[12] 0.0 0.0 1.0 1.0 0.95 0.95 3.5 3.5 nan nan 1.12312312 1.12312312 
arg_in: 2 buffer int[6] 0 2 4 -1 1 2031231231

[test]
name: ldexp float4
kernel_name: test_4_ldexp_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 4.0 4.0 4.0 4.0 15.2 15.2 15.2 15.2 1.75 1.75 1.75 1.75 nan nan nan nan inf inf inf inf  tolerance 0 ulp
arg_in: 1 buffer float[24] 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.95 0.95 0.95 0.95 3.5 3.5 3.5 3.5 nan nan nan nan 1.12312312 1.12312312 1.12312312 1.12312312 
arg_in: 2 buffer int[24] 0 0 0 0 2 2 2 2 4 4 4 4 -1 -1 -1 -1 1 1 1 1 2031231231 2031231231 2031231231 2031231231 

[test]
name: tss_ldexp float4
kernel_name: test_tss_4_ldexp_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 4.0 4.0 4.0 4.0 15.2 15.2 15.2 15.2 1.75 1.75 1.75 1.75 nan nan nan nan inf inf inf inf  tolerance 0 ulp
arg_in: 1 buffer float[24] 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.95 0.95 0.95 0.95 3.5 3.5 3.5 3.5 nan nan nan nan 1.12312312 1.12312312 1.12312312 1.12312312 
arg_in: 2 buffer int[6] 0 2 4 -1 1 2031231231

[test]
name: ldexp float8
kernel_name: test_8_ldexp_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf  tolerance 0 ulp
arg_in: 1 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 nan nan nan nan nan nan nan nan 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 
arg_in: 2 buffer int[48] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 2031231231 2031231231 2031231231 2031231231 2031231231 2031231231 2031231231 2031231231 

[test]
name: tss_ldexp float8
kernel_name: test_tss_8_ldexp_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf  tolerance 0 ulp
arg_in: 1 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 nan nan nan nan nan nan nan nan 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 
arg_in: 2 buffer int[6] 0 2 4 -1 1 2031231231

[test]
name: ldexp float16
kernel_name: test_16_ldexp_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf  tolerance 0 ulp
arg_in: 1 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 
arg_in: 2 buffer int[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2031231231 2031231231 2031231231 2031231231 2031231231 2031231231 2031231231 2031231231 2031231231 2031231231 2031231231 2031231231 2031231231 2031231231 2031231231 2031231231 

[test]
name: tss_ldexp float16
kernel_name: test_tss_16_ldexp_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 15.2 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 1.75 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf  tolerance 0 ulp
arg_in: 1 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 1.12312312 
arg_in: 2 buffer int[6] 0 2 4 -1 1 2031231231

!*/

kernel void test_1_ldexp_float(global float* out, global float* in0, global int* in1){
  out[get_global_id(0)] = ldexp(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_ldexp_float(global float* out, global float* in0, global int* in1){
  vstore2(ldexp(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_ldexp_float(global float* out, global float* in0, global int* in1){
  vstore4(ldexp(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_ldexp_float(global float* out, global float* in0, global int* in1){
  vstore8(ldexp(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_ldexp_float(global float* out, global float* in0, global int* in1){
  vstore16(ldexp(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_tss_2_ldexp_float(global float* out, global float* in0, global int* in1){
  vstore2(ldexp(vload2(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_ldexp_float(global float* out, global float* in0, global int* in1){
  vstore4(ldexp(vload4(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_ldexp_float(global float* out, global float* in0, global int* in1){
  vstore8(ldexp(vload8(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_ldexp_float(global float* out, global float* in0, global int* in1){
  vstore16(ldexp(vload16(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

