/*!
[config]
name: Test float hypot built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: hypot float1
kernel_name: test_1_hypot_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 1.0 10.44030650891055 3.1622776601683795 1234.5405015632334 2147483647.0 inf  tolerance 4 ulp
arg_in: 1 buffer float[6] 0 3 1 10 2147483647 2147483647 
arg_in: 2 buffer float[6] 1.0 10.0 -3.0 1234.5 -1.0 -inf 

[test]
name: hypot float2
kernel_name: test_2_hypot_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 1.0 1.0 10.44030650891055 10.44030650891055 3.1622776601683795 3.1622776601683795 1234.5405015632334 1234.5405015632334 2147483647.0 2147483647.0 inf inf  tolerance 4 ulp
arg_in: 1 buffer float[12] 0 0 3 3 1 1 10 10 2147483647 2147483647 2147483647 2147483647 
arg_in: 2 buffer float[12] 1.0 1.0 10.0 10.0 -3.0 -3.0 1234.5 1234.5 -1.0 -1.0 -inf -inf 

[test]
name: hypot float4
kernel_name: test_4_hypot_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 1.0 1.0 1.0 1.0 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 2147483647.0 2147483647.0 2147483647.0 2147483647.0 inf inf inf inf  tolerance 4 ulp
arg_in: 1 buffer float[24] 0 0 0 0 3 3 3 3 1 1 1 1 10 10 10 10 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 
arg_in: 2 buffer float[24] 1.0 1.0 1.0 1.0 10.0 10.0 10.0 10.0 -3.0 -3.0 -3.0 -3.0 1234.5 1234.5 1234.5 1234.5 -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf 

[test]
name: hypot float8
kernel_name: test_8_hypot_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 inf inf inf inf inf inf inf inf  tolerance 4 ulp
arg_in: 1 buffer float[48] 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 1 1 1 1 1 1 1 1 10 10 10 10 10 10 10 10 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 
arg_in: 2 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf -inf -inf -inf -inf 

[test]
name: hypot float16
kernel_name: test_16_hypot_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 10.44030650891055 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 3.1622776601683795 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 1234.5405015632334 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 2147483647.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf  tolerance 4 ulp
arg_in: 1 buffer float[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 
arg_in: 2 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 

!*/

kernel void test_1_hypot_float(global float* out, global float* in0, global float* in1){
  out[get_global_id(0)] = hypot(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_hypot_float(global float* out, global float* in0, global float* in1){
  vstore2(hypot(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_hypot_float(global float* out, global float* in0, global float* in1){
  vstore4(hypot(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_hypot_float(global float* out, global float* in0, global float* in1){
  vstore8(hypot(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_hypot_float(global float* out, global float* in0, global float* in1){
  vstore16(hypot(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

