/*!
[config]
name: Test float frexp built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: frexp_private float1
kernel_name: test_1_frexp_private_float
global_size: 7 0 0

arg_out: 0 buffer float[7] 0.602783203125 0.5 nan nan inf -inf 0.0  tolerance 0 ulp
arg_out: 1 buffer int[7] 11 1 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[7] 1234.5 1.0 nan nan inf -inf 0.0 

[test]
name: frexp_local float1
kernel_name: test_1_frexp_local_float
global_size: 7 0 0

arg_out: 0 buffer float[7] 0.602783203125 0.5 nan nan inf -inf 0.0  tolerance 0 ulp
arg_out: 1 buffer int[7] 11 1 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[7] 1234.5 1.0 nan nan inf -inf 0.0 

[test]
name: frexp_global float1
kernel_name: test_1_frexp_global_float
global_size: 7 0 0

arg_out: 0 buffer float[7] 0.602783203125 0.5 nan nan inf -inf 0.0  tolerance 0 ulp
arg_out: 1 buffer int[7] 11 1 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[7] 1234.5 1.0 nan nan inf -inf 0.0 

[test]
name: frexp_private float2
kernel_name: test_2_frexp_private_float
global_size: 7 0 0

arg_out: 0 buffer float[14] 0.602783203125 0.602783203125 0.5 0.5 nan nan nan nan inf inf -inf -inf 0.0 0.0  tolerance 0 ulp
arg_out: 1 buffer int[14] 11 11 1 1 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[14] 1234.5 1234.5 1.0 1.0 nan nan nan nan inf inf -inf -inf 0.0 0.0 

[test]
name: frexp_local float2
kernel_name: test_2_frexp_local_float
global_size: 7 0 0

arg_out: 0 buffer float[14] 0.602783203125 0.602783203125 0.5 0.5 nan nan nan nan inf inf -inf -inf 0.0 0.0  tolerance 0 ulp
arg_out: 1 buffer int[14] 11 11 1 1 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[14] 1234.5 1234.5 1.0 1.0 nan nan nan nan inf inf -inf -inf 0.0 0.0 

[test]
name: frexp_global float2
kernel_name: test_2_frexp_global_float
global_size: 7 0 0

arg_out: 0 buffer float[14] 0.602783203125 0.602783203125 0.5 0.5 nan nan nan nan inf inf -inf -inf 0.0 0.0  tolerance 0 ulp
arg_out: 1 buffer int[14] 11 11 1 1 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[14] 1234.5 1234.5 1.0 1.0 nan nan nan nan inf inf -inf -inf 0.0 0.0 

[test]
name: frexp_private float4
kernel_name: test_4_frexp_private_float
global_size: 7 0 0

arg_out: 0 buffer float[28] 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.5 0.5 0.5 0.5 nan nan nan nan nan nan nan nan inf inf inf inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_out: 1 buffer int[28] 11 11 11 11 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[28] 1234.5 1234.5 1234.5 1234.5 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan inf inf inf inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 

[test]
name: frexp_local float4
kernel_name: test_4_frexp_local_float
global_size: 7 0 0

arg_out: 0 buffer float[28] 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.5 0.5 0.5 0.5 nan nan nan nan nan nan nan nan inf inf inf inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_out: 1 buffer int[28] 11 11 11 11 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[28] 1234.5 1234.5 1234.5 1234.5 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan inf inf inf inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 

[test]
name: frexp_global float4
kernel_name: test_4_frexp_global_float
global_size: 7 0 0

arg_out: 0 buffer float[28] 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.5 0.5 0.5 0.5 nan nan nan nan nan nan nan nan inf inf inf inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_out: 1 buffer int[28] 11 11 11 11 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[28] 1234.5 1234.5 1234.5 1234.5 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan inf inf inf inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 

[test]
name: frexp_private float8
kernel_name: test_8_frexp_private_float
global_size: 7 0 0

arg_out: 0 buffer float[56] 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_out: 1 buffer int[56] 11 11 11 11 11 11 11 11 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[56] 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

[test]
name: frexp_local float8
kernel_name: test_8_frexp_local_float
global_size: 7 0 0

arg_out: 0 buffer float[56] 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_out: 1 buffer int[56] 11 11 11 11 11 11 11 11 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[56] 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

[test]
name: frexp_global float8
kernel_name: test_8_frexp_global_float
global_size: 7 0 0

arg_out: 0 buffer float[56] 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_out: 1 buffer int[56] 11 11 11 11 11 11 11 11 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[56] 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

[test]
name: frexp_private float16
kernel_name: test_16_frexp_private_float
global_size: 7 0 0

arg_out: 0 buffer float[112] 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_out: 1 buffer int[112] 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[112] 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

[test]
name: frexp_local float16
kernel_name: test_16_frexp_local_float
global_size: 7 0 0

arg_out: 0 buffer float[112] 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_out: 1 buffer int[112] 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[112] 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

[test]
name: frexp_global float16
kernel_name: test_16_frexp_global_float
global_size: 7 0 0

arg_out: 0 buffer float[112] 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.602783203125 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_out: 1 buffer int[112] 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 2 buffer float[112] 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1234.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

!*/

kernel void test_1_frexp_private_float(global float* out, global int* out1, global float* in0){
  private int tmp1;
  out[get_global_id(0)] = frexp(in0[get_global_id(0)], &tmp1);
  out1[get_global_id(0)] = tmp1;
}

kernel void test_2_frexp_private_float(global float* out, global int* out1, global float* in0){
  private int2 tmp1;
  vstore2(frexp(vload2(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore2(tmp1, get_global_id(0), out1);
}

kernel void test_4_frexp_private_float(global float* out, global int* out1, global float* in0){
  private int4 tmp1;
  vstore4(frexp(vload4(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore4(tmp1, get_global_id(0), out1);
}

kernel void test_8_frexp_private_float(global float* out, global int* out1, global float* in0){
  private int8 tmp1;
  vstore8(frexp(vload8(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore8(tmp1, get_global_id(0), out1);
}

kernel void test_16_frexp_private_float(global float* out, global int* out1, global float* in0){
  private int16 tmp1;
  vstore16(frexp(vload16(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore16(tmp1, get_global_id(0), out1);
}

kernel void test_1_frexp_local_float(global float* out, global int* out1, global float* in0){
  local int tmp1;
  out[get_global_id(0)] = frexp(in0[get_global_id(0)], &tmp1);
  out1[get_global_id(0)] = tmp1;
}

kernel void test_2_frexp_local_float(global float* out, global int* out1, global float* in0){
  local int2 tmp1;
  vstore2(frexp(vload2(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore2(tmp1, get_global_id(0), out1);
}

kernel void test_4_frexp_local_float(global float* out, global int* out1, global float* in0){
  local int4 tmp1;
  vstore4(frexp(vload4(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore4(tmp1, get_global_id(0), out1);
}

kernel void test_8_frexp_local_float(global float* out, global int* out1, global float* in0){
  local int8 tmp1;
  vstore8(frexp(vload8(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore8(tmp1, get_global_id(0), out1);
}

kernel void test_16_frexp_local_float(global float* out, global int* out1, global float* in0){
  local int16 tmp1;
  vstore16(frexp(vload16(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore16(tmp1, get_global_id(0), out1);
}

kernel void test_1_frexp_global_float(global float* out, global int* out1, global float* in0){
  global int *tmp1 = out1;
  out[get_global_id(0)] = frexp(in0[get_global_id(0)], &tmp1[get_global_id(0)]);
}

kernel void test_2_frexp_global_float(global float* out, global int* out1, global float* in0){
  global int2 *tmp1 = out1;
  vstore2(frexp(vload2(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_4_frexp_global_float(global float* out, global int* out1, global float* in0){
  global int4 *tmp1 = out1;
  vstore4(frexp(vload4(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_8_frexp_global_float(global float* out, global int* out1, global float* in0){
  global int8 *tmp1 = out1;
  vstore8(frexp(vload8(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_16_frexp_global_float(global float* out, global int* out1, global float* in0){
  global int16 *tmp1 = out1;
  vstore16(frexp(vload16(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

