/*!
[config]
name: Test float fract built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: fract_private float1
kernel_name: test_1_fract_private_float
global_size: 6 0 0

arg_out: 0 buffer float[6] nan 0.0 0.5 0.0 0.2999999523162842 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[6] nan inf 1.0 2.0 -2.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[6] nan inf 1.5 2.0 -1.7000000476837158 -5.960669824389697e-08 

[test]
name: fract_local float1
kernel_name: test_1_fract_local_float
global_size: 6 0 0

arg_out: 0 buffer float[6] nan 0.0 0.5 0.0 0.2999999523162842 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[6] nan inf 1.0 2.0 -2.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[6] nan inf 1.5 2.0 -1.7000000476837158 -5.960669824389697e-08 

[test]
name: fract_global float1
kernel_name: test_1_fract_global_float
global_size: 6 0 0

arg_out: 0 buffer float[6] nan 0.0 0.5 0.0 0.2999999523162842 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[6] nan inf 1.0 2.0 -2.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[6] nan inf 1.5 2.0 -1.7000000476837158 -5.960669824389697e-08 

[test]
name: fract_private float2
kernel_name: test_2_fract_private_float
global_size: 6 0 0

arg_out: 0 buffer float[12] nan nan 0.0 0.0 0.5 0.5 0.0 0.0 0.2999999523162842 0.2999999523162842 0.9999999403953552 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[12] nan nan inf inf 1.0 1.0 2.0 2.0 -2.0 -2.0 -1.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[12] nan nan inf inf 1.5 1.5 2.0 2.0 -1.7000000476837158 -1.7000000476837158 -5.960669824389697e-08 -5.960669824389697e-08 

[test]
name: fract_local float2
kernel_name: test_2_fract_local_float
global_size: 6 0 0

arg_out: 0 buffer float[12] nan nan 0.0 0.0 0.5 0.5 0.0 0.0 0.2999999523162842 0.2999999523162842 0.9999999403953552 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[12] nan nan inf inf 1.0 1.0 2.0 2.0 -2.0 -2.0 -1.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[12] nan nan inf inf 1.5 1.5 2.0 2.0 -1.7000000476837158 -1.7000000476837158 -5.960669824389697e-08 -5.960669824389697e-08 

[test]
name: fract_global float2
kernel_name: test_2_fract_global_float
global_size: 6 0 0

arg_out: 0 buffer float[12] nan nan 0.0 0.0 0.5 0.5 0.0 0.0 0.2999999523162842 0.2999999523162842 0.9999999403953552 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[12] nan nan inf inf 1.0 1.0 2.0 2.0 -2.0 -2.0 -1.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[12] nan nan inf inf 1.5 1.5 2.0 2.0 -1.7000000476837158 -1.7000000476837158 -5.960669824389697e-08 -5.960669824389697e-08 

[test]
name: fract_private float4
kernel_name: test_4_fract_private_float
global_size: 6 0 0

arg_out: 0 buffer float[24] nan nan nan nan 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[24] nan nan nan nan inf inf inf inf 1.0 1.0 1.0 1.0 2.0 2.0 2.0 2.0 -2.0 -2.0 -2.0 -2.0 -1.0 -1.0 -1.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[24] nan nan nan nan inf inf inf inf 1.5 1.5 1.5 1.5 2.0 2.0 2.0 2.0 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 

[test]
name: fract_local float4
kernel_name: test_4_fract_local_float
global_size: 6 0 0

arg_out: 0 buffer float[24] nan nan nan nan 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[24] nan nan nan nan inf inf inf inf 1.0 1.0 1.0 1.0 2.0 2.0 2.0 2.0 -2.0 -2.0 -2.0 -2.0 -1.0 -1.0 -1.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[24] nan nan nan nan inf inf inf inf 1.5 1.5 1.5 1.5 2.0 2.0 2.0 2.0 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 

[test]
name: fract_global float4
kernel_name: test_4_fract_global_float
global_size: 6 0 0

arg_out: 0 buffer float[24] nan nan nan nan 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[24] nan nan nan nan inf inf inf inf 1.0 1.0 1.0 1.0 2.0 2.0 2.0 2.0 -2.0 -2.0 -2.0 -2.0 -1.0 -1.0 -1.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[24] nan nan nan nan inf inf inf inf 1.5 1.5 1.5 1.5 2.0 2.0 2.0 2.0 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 

[test]
name: fract_private float8
kernel_name: test_8_fract_private_float
global_size: 6 0 0

arg_out: 0 buffer float[48] nan nan nan nan nan nan nan nan 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[48] nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[48] nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 

[test]
name: fract_local float8
kernel_name: test_8_fract_local_float
global_size: 6 0 0

arg_out: 0 buffer float[48] nan nan nan nan nan nan nan nan 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[48] nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[48] nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 

[test]
name: fract_global float8
kernel_name: test_8_fract_global_float
global_size: 6 0 0

arg_out: 0 buffer float[48] nan nan nan nan nan nan nan nan 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[48] nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[48] nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 

[test]
name: fract_private float16
kernel_name: test_16_fract_private_float
global_size: 6 0 0

arg_out: 0 buffer float[96] nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[96] nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[96] nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 

[test]
name: fract_local float16
kernel_name: test_16_fract_local_float
global_size: 6 0 0

arg_out: 0 buffer float[96] nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[96] nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[96] nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 

[test]
name: fract_global float16
kernel_name: test_16_fract_global_float
global_size: 6 0 0

arg_out: 0 buffer float[96] nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.2999999523162842 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552 0.9999999403953552  tolerance 0 ulp
arg_out: 1 buffer float[96] nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0  tolerance 0 ulp
arg_in: 2 buffer float[96] nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -1.7000000476837158 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 -5.960669824389697e-08 

!*/

kernel void test_1_fract_private_float(global float* out, global float* out1, global float* in0){
  private float tmp1;
  out[get_global_id(0)] = fract(in0[get_global_id(0)], &tmp1);
  out1[get_global_id(0)] = tmp1;
}

kernel void test_2_fract_private_float(global float* out, global float* out1, global float* in0){
  private float2 tmp1;
  vstore2(fract(vload2(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore2(tmp1, get_global_id(0), out1);
}

kernel void test_4_fract_private_float(global float* out, global float* out1, global float* in0){
  private float4 tmp1;
  vstore4(fract(vload4(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore4(tmp1, get_global_id(0), out1);
}

kernel void test_8_fract_private_float(global float* out, global float* out1, global float* in0){
  private float8 tmp1;
  vstore8(fract(vload8(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore8(tmp1, get_global_id(0), out1);
}

kernel void test_16_fract_private_float(global float* out, global float* out1, global float* in0){
  private float16 tmp1;
  vstore16(fract(vload16(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore16(tmp1, get_global_id(0), out1);
}

kernel void test_1_fract_local_float(global float* out, global float* out1, global float* in0){
  local float tmp1;
  out[get_global_id(0)] = fract(in0[get_global_id(0)], &tmp1);
  out1[get_global_id(0)] = tmp1;
}

kernel void test_2_fract_local_float(global float* out, global float* out1, global float* in0){
  local float2 tmp1;
  vstore2(fract(vload2(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore2(tmp1, get_global_id(0), out1);
}

kernel void test_4_fract_local_float(global float* out, global float* out1, global float* in0){
  local float4 tmp1;
  vstore4(fract(vload4(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore4(tmp1, get_global_id(0), out1);
}

kernel void test_8_fract_local_float(global float* out, global float* out1, global float* in0){
  local float8 tmp1;
  vstore8(fract(vload8(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore8(tmp1, get_global_id(0), out1);
}

kernel void test_16_fract_local_float(global float* out, global float* out1, global float* in0){
  local float16 tmp1;
  vstore16(fract(vload16(get_global_id(0), in0), &tmp1), get_global_id(0), out);
  vstore16(tmp1, get_global_id(0), out1);
}

kernel void test_1_fract_global_float(global float* out, global float* out1, global float* in0){
  global float *tmp1 = out1;
  out[get_global_id(0)] = fract(in0[get_global_id(0)], &tmp1[get_global_id(0)]);
}

kernel void test_2_fract_global_float(global float* out, global float* out1, global float* in0){
  global float2 *tmp1 = out1;
  vstore2(fract(vload2(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_4_fract_global_float(global float* out, global float* out1, global float* in0){
  global float4 *tmp1 = out1;
  vstore4(fract(vload4(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_8_fract_global_float(global float* out, global float* out1, global float* in0){
  global float8 *tmp1 = out1;
  vstore8(fract(vload8(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_16_fract_global_float(global float* out, global float* out1, global float* in0){
  global float16 *tmp1 = out1;
  vstore16(fract(vload16(get_global_id(0), in0), &tmp1[get_global_id(0)]), get_global_id(0), out);
}

