/*!
[config]
name: Test float fmod built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: fmod float1
kernel_name: test_1_fmod_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 0.09999990463256836 nan -0.009999990463256836 1.0 nan nan  tolerance 0 ulp
arg_in: 1 buffer float[6] 5.099999904632568 0.0 -4.0 1.0 5.1 3.0 
arg_in: 2 buffer float[6] 0.5 nan -3.990000009536743 1.5 0.0 inf 

[test]
name: fmod float2
kernel_name: test_2_fmod_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0.09999990463256836 0.09999990463256836 nan nan -0.009999990463256836 -0.009999990463256836 1.0 1.0 nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[12] 5.099999904632568 5.099999904632568 0.0 0.0 -4.0 -4.0 1.0 1.0 5.1 5.1 3.0 3.0 
arg_in: 2 buffer float[12] 0.5 0.5 nan nan -3.990000009536743 -3.990000009536743 1.5 1.5 0.0 0.0 inf inf 

[test]
name: fmod float4
kernel_name: test_4_fmod_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 nan nan nan nan -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[24] 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 0.0 0.0 0.0 0.0 -4.0 -4.0 -4.0 -4.0 1.0 1.0 1.0 1.0 5.1 5.1 5.1 5.1 3.0 3.0 3.0 3.0 
arg_in: 2 buffer float[24] 0.5 0.5 0.5 0.5 nan nan nan nan -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 1.5 1.5 1.5 1.5 0.0 0.0 0.0 0.0 inf inf inf inf 

[test]
name: fmod float8
kernel_name: test_8_fmod_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 nan nan nan nan nan nan nan nan -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[48] 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 
arg_in: 2 buffer float[48] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 nan nan nan nan nan nan nan nan -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 inf inf inf inf inf inf inf inf 

[test]
name: fmod float16
kernel_name: test_16_fmod_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 0.09999990463256836 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 -0.009999990463256836 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[96] 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 5.099999904632568 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 5.1 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 
arg_in: 2 buffer float[96] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 -3.990000009536743 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 

!*/

kernel void test_1_fmod_float(global float* out, global float* in0, global float* in1){
  out[get_global_id(0)] = fmod(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_fmod_float(global float* out, global float* in0, global float* in1){
  vstore2(fmod(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_fmod_float(global float* out, global float* in0, global float* in1){
  vstore4(fmod(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_fmod_float(global float* out, global float* in0, global float* in1){
  vstore8(fmod(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_fmod_float(global float* out, global float* in0, global float* in1){
  vstore16(fmod(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

