/*!
[config]
name: Test float fma built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: fma float1
kernel_name: test_1_fma_float
global_size: 7 0 0

arg_out: 0 buffer float[7] 3.141592653589793 1.0 3.141592653589793 -0.5 nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[7] 1.0 3.141592653589793 0.0 0.0 1.0 nan nan 
arg_in: 2 buffer float[7] 3.141592653589793 0.0 3.141592653589793 -0.5 nan 1.0 nan 
arg_in: 3 buffer float[7] 0.0 1.0 3.141592653589793 -0.5 nan 1.0 nan 

[test]
name: fma float2
kernel_name: test_2_fma_float
global_size: 7 0 0

arg_out: 0 buffer float[14] 3.141592653589793 3.141592653589793 1.0 1.0 3.141592653589793 3.141592653589793 -0.5 -0.5 nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[14] 1.0 1.0 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 1.0 1.0 nan nan nan nan 
arg_in: 2 buffer float[14] 3.141592653589793 3.141592653589793 0.0 0.0 3.141592653589793 3.141592653589793 -0.5 -0.5 nan nan 1.0 1.0 nan nan 
arg_in: 3 buffer float[14] 0.0 0.0 1.0 1.0 3.141592653589793 3.141592653589793 -0.5 -0.5 nan nan 1.0 1.0 nan nan 

[test]
name: tss_fma float2
kernel_name: test_tss_2_fma_float
global_size: 7 0 0

arg_out: 0 buffer float[14] 3.141592653589793 3.141592653589793 1.0 1.0 3.141592653589793 3.141592653589793 -0.5 -0.5 nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[14] 1.0 1.0 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 1.0 1.0 nan nan nan nan 
arg_in: 2 buffer float[7] 3.141592653589793 0.0 3.141592653589793 -0.5 nan 1.0 nan
arg_in: 3 buffer float[7] 0.0 1.0 3.141592653589793 -0.5 nan 1.0 nan

[test]
name: fma float4
kernel_name: test_4_fma_float
global_size: 7 0 0

arg_out: 0 buffer float[28] 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.5 -0.5 -0.5 -0.5 nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[28] 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[28] 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.5 -0.5 -0.5 -0.5 nan nan nan nan 1.0 1.0 1.0 1.0 nan nan nan nan 
arg_in: 3 buffer float[28] 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.5 -0.5 -0.5 -0.5 nan nan nan nan 1.0 1.0 1.0 1.0 nan nan nan nan 

[test]
name: tss_fma float4
kernel_name: test_tss_4_fma_float
global_size: 7 0 0

arg_out: 0 buffer float[28] 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.5 -0.5 -0.5 -0.5 nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[28] 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[7] 3.141592653589793 0.0 3.141592653589793 -0.5 nan 1.0 nan
arg_in: 3 buffer float[7] 0.0 1.0 3.141592653589793 -0.5 nan 1.0 nan

[test]
name: fma float8
kernel_name: test_8_fma_float
global_size: 7 0 0

arg_out: 0 buffer float[56] 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[56] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[56] 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan 
arg_in: 3 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan 

[test]
name: tss_fma float8
kernel_name: test_tss_8_fma_float
global_size: 7 0 0

arg_out: 0 buffer float[56] 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[56] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[7] 3.141592653589793 0.0 3.141592653589793 -0.5 nan 1.0 nan
arg_in: 3 buffer float[7] 0.0 1.0 3.141592653589793 -0.5 nan 1.0 nan

[test]
name: fma float16
kernel_name: test_16_fma_float
global_size: 7 0 0

arg_out: 0 buffer float[112] 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[112] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[112] 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 
arg_in: 3 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

[test]
name: tss_fma float16
kernel_name: test_tss_16_fma_float
global_size: 7 0 0

arg_out: 0 buffer float[112] 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[112] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[7] 3.141592653589793 0.0 3.141592653589793 -0.5 nan 1.0 nan
arg_in: 3 buffer float[7] 0.0 1.0 3.141592653589793 -0.5 nan 1.0 nan

!*/

kernel void test_1_fma_float(global float* out, global float* in0, global float* in1, global float* in2){
  out[get_global_id(0)] = fma(in0[get_global_id(0)], in1[get_global_id(0)], in2[get_global_id(0)]);
}

kernel void test_2_fma_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore2(fma(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), vload2(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_4_fma_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore4(fma(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), vload4(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_8_fma_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore8(fma(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), vload8(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_16_fma_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore16(fma(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), vload16(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_tss_2_fma_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore2(fma(vload2(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_fma_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore4(fma(vload4(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_fma_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore8(fma(vload8(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_fma_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore16(fma(vload16(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

