/*!
[config]
name: Test float fdim built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: fdim float1
kernel_name: test_1_fdim_float
global_size: 10 0 0

arg_out: 0 buffer float[10] 0.0 0.75 0.0 0.0 inf 0.0 nan nan nan 2.2469  tolerance 0 ulp
arg_in: 1 buffer float[10] 0.3 1.0 3.141592653589793 0.0 inf inf nan 1.0 nan 1.12345 
arg_in: 2 buffer float[10] 1.5 0.25 3.141592653589793 -0.0 -inf inf nan nan 1.0 -1.12345 

[test]
name: fdim float2
kernel_name: test_2_fdim_float
global_size: 10 0 0

arg_out: 0 buffer float[20] 0.0 0.0 0.75 0.75 0.0 0.0 0.0 0.0 inf inf 0.0 0.0 nan nan nan nan nan nan 2.2469 2.2469  tolerance 0 ulp
arg_in: 1 buffer float[20] 0.3 0.3 1.0 1.0 3.141592653589793 3.141592653589793 0.0 0.0 inf inf inf inf nan nan 1.0 1.0 nan nan 1.12345 1.12345 
arg_in: 2 buffer float[20] 1.5 1.5 0.25 0.25 3.141592653589793 3.141592653589793 -0.0 -0.0 -inf -inf inf inf nan nan nan nan 1.0 1.0 -1.12345 -1.12345 

[test]
name: fdim float4
kernel_name: test_4_fdim_float
global_size: 10 0 0

arg_out: 0 buffer float[40] 0.0 0.0 0.0 0.0 0.75 0.75 0.75 0.75 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 inf inf inf inf 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan 2.2469 2.2469 2.2469 2.2469  tolerance 0 ulp
arg_in: 1 buffer float[40] 0.3 0.3 0.3 0.3 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 inf inf inf inf inf inf inf inf nan nan nan nan 1.0 1.0 1.0 1.0 nan nan nan nan 1.12345 1.12345 1.12345 1.12345 
arg_in: 2 buffer float[40] 1.5 1.5 1.5 1.5 0.25 0.25 0.25 0.25 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.0 -0.0 -0.0 -0.0 -inf -inf -inf -inf inf inf inf inf nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 -1.12345 -1.12345 -1.12345 -1.12345 

[test]
name: fdim float8
kernel_name: test_8_fdim_float
global_size: 10 0 0

arg_out: 0 buffer float[80] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 inf inf inf inf inf inf inf inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 2.2469 2.2469 2.2469 2.2469 2.2469 2.2469 2.2469 2.2469  tolerance 0 ulp
arg_in: 1 buffer float[80] 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 
arg_in: 2 buffer float[80] 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -inf -inf -inf -inf -inf -inf -inf -inf inf inf inf inf inf inf inf inf nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 

[test]
name: fdim float16
kernel_name: test_16_fdim_float
global_size: 10 0 0

arg_out: 0 buffer float[160] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 2.2469 2.2469 2.2469 2.2469 2.2469 2.2469 2.2469 2.2469 2.2469 2.2469 2.2469 2.2469 2.2469 2.2469 2.2469 2.2469  tolerance 0 ulp
arg_in: 1 buffer float[160] 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 
arg_in: 2 buffer float[160] 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 

!*/

kernel void test_1_fdim_float(global float* out, global float* in0, global float* in1){
  out[get_global_id(0)] = fdim(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_fdim_float(global float* out, global float* in0, global float* in1){
  vstore2(fdim(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_fdim_float(global float* out, global float* in0, global float* in1){
  vstore4(fdim(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_fdim_float(global float* out, global float* in0, global float* in1){
  vstore8(fdim(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_fdim_float(global float* out, global float* in0, global float* in1){
  vstore16(fdim(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

