/*!
[config]
name: Test float fabs built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: fabs float1
kernel_name: test_1_fabs_float
global_size: 7 0 0

arg_out: 0 buffer float[7] 0.0 1.5707963267948966 3.141592653589793 0.0 inf inf 1.12345  tolerance 0 ulp
arg_in: 1 buffer float[7] 0.0 -1.5707963267948966 3.141592653589793 -0.0 -inf inf -1.12345 

[test]
name: fabs float2
kernel_name: test_2_fabs_float
global_size: 7 0 0

arg_out: 0 buffer float[14] 0.0 0.0 1.5707963267948966 1.5707963267948966 3.141592653589793 3.141592653589793 0.0 0.0 inf inf inf inf 1.12345 1.12345  tolerance 0 ulp
arg_in: 1 buffer float[14] 0.0 0.0 -1.5707963267948966 -1.5707963267948966 3.141592653589793 3.141592653589793 -0.0 -0.0 -inf -inf inf inf -1.12345 -1.12345 

[test]
name: fabs float4
kernel_name: test_4_fabs_float
global_size: 7 0 0

arg_out: 0 buffer float[28] 0.0 0.0 0.0 0.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 inf inf inf inf inf inf inf inf 1.12345 1.12345 1.12345 1.12345  tolerance 0 ulp
arg_in: 1 buffer float[28] 0.0 0.0 0.0 0.0 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.0 -0.0 -0.0 -0.0 -inf -inf -inf -inf inf inf inf inf -1.12345 -1.12345 -1.12345 -1.12345 

[test]
name: fabs float8
kernel_name: test_8_fabs_float
global_size: 7 0 0

arg_out: 0 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345  tolerance 0 ulp
arg_in: 1 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -inf -inf -inf -inf -inf -inf -inf -inf inf inf inf inf inf inf inf inf -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 

[test]
name: fabs float16
kernel_name: test_16_fabs_float
global_size: 7 0 0

arg_out: 0 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345  tolerance 0 ulp
arg_in: 1 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 

!*/

kernel void test_1_fabs_float(global float* out, global float* in0){
  out[get_global_id(0)] = fabs(in0[get_global_id(0)]);
}

kernel void test_2_fabs_float(global float* out, global float* in0){
  vstore2(fabs(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_fabs_float(global float* out, global float* in0){
  vstore4(fabs(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_fabs_float(global float* out, global float* in0){
  vstore8(fabs(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_fabs_float(global float* out, global float* in0){
  vstore16(fabs(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

