/*!
[config]
name: Test float expm1 built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: expm1 float1
kernel_name: test_1_expm1_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 0.0 1.585709659315846 22.140692632779267 -0.9567860817362277 inf 21.43714340788687  tolerance 3 ulp
arg_in: 1 buffer float[6] 0.0 0.95 3.141592653589793 -3.141592653589793 inf 3.1107177734375 

[test]
name: expm1 float2
kernel_name: test_2_expm1_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0.0 0.0 1.585709659315846 1.585709659315846 22.140692632779267 22.140692632779267 -0.9567860817362277 -0.9567860817362277 inf inf 21.43714340788687 21.43714340788687  tolerance 3 ulp
arg_in: 1 buffer float[12] 0.0 0.0 0.95 0.95 3.141592653589793 3.141592653589793 -3.141592653589793 -3.141592653589793 inf inf 3.1107177734375 3.1107177734375 

[test]
name: expm1 float4
kernel_name: test_4_expm1_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 inf inf inf inf 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687  tolerance 3 ulp
arg_in: 1 buffer float[24] 0.0 0.0 0.0 0.0 0.95 0.95 0.95 0.95 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 inf inf inf inf 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 

[test]
name: expm1 float8
kernel_name: test_8_expm1_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 inf inf inf inf inf inf inf inf 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687  tolerance 3 ulp
arg_in: 1 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 inf inf inf inf inf inf inf inf 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 

[test]
name: expm1 float16
kernel_name: test_16_expm1_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 1.585709659315846 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 22.140692632779267 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 -0.9567860817362277 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687 21.43714340788687  tolerance 3 ulp
arg_in: 1 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 

!*/

kernel void test_1_expm1_float(global float* out, global float* in0){
  out[get_global_id(0)] = expm1(in0[get_global_id(0)]);
}

kernel void test_2_expm1_float(global float* out, global float* in0){
  vstore2(expm1(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_expm1_float(global float* out, global float* in0){
  vstore4(expm1(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_expm1_float(global float* out, global float* in0){
  vstore8(expm1(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_expm1_float(global float* out, global float* in0){
  vstore16(expm1(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

