/*!
[config]
name: Test float exp2 built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: exp2 float1
kernel_name: test_1_exp2_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 1.0 1.931872657849691 8.824977827076287 0.11331473229676088 inf 8.638122484576291  tolerance 3 ulp
arg_in: 1 buffer float[6] 0.0 0.95 3.141592653589793 -3.141592653589793 inf 3.1107177734375 

[test]
name: exp2 float2
kernel_name: test_2_exp2_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 1.0 1.0 1.931872657849691 1.931872657849691 8.824977827076287 8.824977827076287 0.11331473229676088 0.11331473229676088 inf inf 8.638122484576291 8.638122484576291  tolerance 3 ulp
arg_in: 1 buffer float[12] 0.0 0.0 0.95 0.95 3.141592653589793 3.141592653589793 -3.141592653589793 -3.141592653589793 inf inf 3.1107177734375 3.1107177734375 

[test]
name: exp2 float4
kernel_name: test_4_exp2_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 1.0 1.0 1.0 1.0 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 inf inf inf inf 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291  tolerance 3 ulp
arg_in: 1 buffer float[24] 0.0 0.0 0.0 0.0 0.95 0.95 0.95 0.95 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 inf inf inf inf 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 

[test]
name: exp2 float8
kernel_name: test_8_exp2_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 inf inf inf inf inf inf inf inf 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291  tolerance 3 ulp
arg_in: 1 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 inf inf inf inf inf inf inf inf 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 

[test]
name: exp2 float16
kernel_name: test_16_exp2_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 1.931872657849691 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 8.824977827076287 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 0.11331473229676088 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291 8.638122484576291  tolerance 3 ulp
arg_in: 1 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 

!*/

kernel void test_1_exp2_float(global float* out, global float* in0){
  out[get_global_id(0)] = exp2(in0[get_global_id(0)]);
}

kernel void test_2_exp2_float(global float* out, global float* in0){
  vstore2(exp2(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_exp2_float(global float* out, global float* in0){
  vstore4(exp2(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_exp2_float(global float* out, global float* in0){
  vstore8(exp2(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_exp2_float(global float* out, global float* in0){
  vstore16(exp2(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

