/*!
[config]
name: Test float exp built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: exp float1
kernel_name: test_1_exp_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 1.0 2.585709659315846 23.140692632779267 0.04321391826377226 inf 22.437143325805664  tolerance 3 ulp
arg_in: 1 buffer float[6] 0.0 0.95 3.141592653589793 -3.141592653589793 inf 3.1107177734375 

[test]
name: exp float2
kernel_name: test_2_exp_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 1.0 1.0 2.585709659315846 2.585709659315846 23.140692632779267 23.140692632779267 0.04321391826377226 0.04321391826377226 inf inf 22.437143325805664 22.437143325805664  tolerance 3 ulp
arg_in: 1 buffer float[12] 0.0 0.0 0.95 0.95 3.141592653589793 3.141592653589793 -3.141592653589793 -3.141592653589793 inf inf 3.1107177734375 3.1107177734375 

[test]
name: exp float4
kernel_name: test_4_exp_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 1.0 1.0 1.0 1.0 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 inf inf inf inf 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664  tolerance 3 ulp
arg_in: 1 buffer float[24] 0.0 0.0 0.0 0.0 0.95 0.95 0.95 0.95 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 inf inf inf inf 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 

[test]
name: exp float8
kernel_name: test_8_exp_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 inf inf inf inf inf inf inf inf 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664  tolerance 3 ulp
arg_in: 1 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 inf inf inf inf inf inf inf inf 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 

[test]
name: exp float16
kernel_name: test_16_exp_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 2.585709659315846 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 23.140692632779267 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 0.04321391826377226 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664 22.437143325805664  tolerance 3 ulp
arg_in: 1 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 -3.141592653589793 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 3.1107177734375 

!*/

kernel void test_1_exp_float(global float* out, global float* in0){
  out[get_global_id(0)] = exp(in0[get_global_id(0)]);
}

kernel void test_2_exp_float(global float* out, global float* in0){
  vstore2(exp(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_exp_float(global float* out, global float* in0){
  vstore4(exp(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_exp_float(global float* out, global float* in0){
  vstore8(exp(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_exp_float(global float* out, global float* in0){
  vstore16(exp(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

