/*!
[config]
name: Test float erfc built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: erfc float1
kernel_name: test_1_erfc_float
global_size: 7 0 0

arg_out: 0 buffer float[7] 1.0 0.0499957911670208 0.009995064698159695 1.994999 0.0 0.0 2.0  tolerance 16 ulp
arg_in: 1 buffer float[7] 0.0 1.3859292911256331 1.8215070683365464 -1.9848487347906387 11.1 inf -inf 

[test]
name: erfc float2
kernel_name: test_2_erfc_float
global_size: 7 0 0

arg_out: 0 buffer float[14] 1.0 1.0 0.0499957911670208 0.0499957911670208 0.009995064698159695 0.009995064698159695 1.994999 1.994999 0.0 0.0 0.0 0.0 2.0 2.0  tolerance 16 ulp
arg_in: 1 buffer float[14] 0.0 0.0 1.3859292911256331 1.3859292911256331 1.8215070683365464 1.8215070683365464 -1.9848487347906387 -1.9848487347906387 11.1 11.1 inf inf -inf -inf 

[test]
name: erfc float4
kernel_name: test_4_erfc_float
global_size: 7 0 0

arg_out: 0 buffer float[28] 1.0 1.0 1.0 1.0 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 1.994999 1.994999 1.994999 1.994999 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 2.0 2.0 2.0 2.0  tolerance 16 ulp
arg_in: 1 buffer float[28] 0.0 0.0 0.0 0.0 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 11.1 11.1 11.1 11.1 inf inf inf inf -inf -inf -inf -inf 

[test]
name: erfc float8
kernel_name: test_8_erfc_float
global_size: 7 0 0

arg_out: 0 buffer float[56] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 1.994999 1.994999 1.994999 1.994999 1.994999 1.994999 1.994999 1.994999 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0  tolerance 16 ulp
arg_in: 1 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf 

[test]
name: erfc float16
kernel_name: test_16_erfc_float
global_size: 7 0 0

arg_out: 0 buffer float[112] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.0499957911670208 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 0.009995064698159695 1.994999 1.994999 1.994999 1.994999 1.994999 1.994999 1.994999 1.994999 1.994999 1.994999 1.994999 1.994999 1.994999 1.994999 1.994999 1.994999 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0  tolerance 16 ulp
arg_in: 1 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 

!*/

kernel void test_1_erfc_float(global float* out, global float* in0){
  out[get_global_id(0)] = erfc(in0[get_global_id(0)]);
}

kernel void test_2_erfc_float(global float* out, global float* in0){
  vstore2(erfc(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_erfc_float(global float* out, global float* in0){
  vstore4(erfc(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_erfc_float(global float* out, global float* in0){
  vstore8(erfc(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_erfc_float(global float* out, global float* in0){
  vstore16(erfc(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

