/*!
[config]
name: Test float erf built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: erf float1
kernel_name: test_1_erf_float
global_size: 7 0 0

arg_out: 0 buffer float[7] 0.0 0.950004 0.990005 -0.994999475 1.0 1 -1  tolerance 16 ulp
arg_in: 1 buffer float[7] 0.0 1.3859292911256331 1.8215070683365464 -1.9848487347906387 11.1 inf -inf 

[test]
name: erf float2
kernel_name: test_2_erf_float
global_size: 7 0 0

arg_out: 0 buffer float[14] 0.0 0.0 0.950004 0.950004 0.990005 0.990005 -0.994999475 -0.994999475 1.0 1.0 1 1 -1 -1  tolerance 16 ulp
arg_in: 1 buffer float[14] 0.0 0.0 1.3859292911256331 1.3859292911256331 1.8215070683365464 1.8215070683365464 -1.9848487347906387 -1.9848487347906387 11.1 11.1 inf inf -inf -inf 

[test]
name: erf float4
kernel_name: test_4_erf_float
global_size: 7 0 0

arg_out: 0 buffer float[28] 0.0 0.0 0.0 0.0 0.950004 0.950004 0.950004 0.950004 0.990005 0.990005 0.990005 0.990005 -0.994999475 -0.994999475 -0.994999475 -0.994999475 1.0 1.0 1.0 1.0 1 1 1 1 -1 -1 -1 -1  tolerance 16 ulp
arg_in: 1 buffer float[28] 0.0 0.0 0.0 0.0 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 11.1 11.1 11.1 11.1 inf inf inf inf -inf -inf -inf -inf 

[test]
name: erf float8
kernel_name: test_8_erf_float
global_size: 7 0 0

arg_out: 0 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.950004 0.950004 0.950004 0.950004 0.950004 0.950004 0.950004 0.950004 0.990005 0.990005 0.990005 0.990005 0.990005 0.990005 0.990005 0.990005 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 16 ulp
arg_in: 1 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf 

[test]
name: erf float16
kernel_name: test_16_erf_float
global_size: 7 0 0

arg_out: 0 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.950004 0.950004 0.950004 0.950004 0.950004 0.950004 0.950004 0.950004 0.950004 0.950004 0.950004 0.950004 0.950004 0.950004 0.950004 0.950004 0.990005 0.990005 0.990005 0.990005 0.990005 0.990005 0.990005 0.990005 0.990005 0.990005 0.990005 0.990005 0.990005 0.990005 0.990005 0.990005 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 -0.994999475 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 16 ulp
arg_in: 1 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.3859292911256331 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 1.8215070683365464 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 -1.9848487347906387 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 11.1 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 

!*/

kernel void test_1_erf_float(global float* out, global float* in0){
  out[get_global_id(0)] = erf(in0[get_global_id(0)]);
}

kernel void test_2_erf_float(global float* out, global float* in0){
  vstore2(erf(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_erf_float(global float* out, global float* in0){
  vstore4(erf(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_erf_float(global float* out, global float* in0){
  vstore8(erf(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_erf_float(global float* out, global float* in0){
  vstore16(erf(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

