/*!
[config]
name: Test float cospi built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: cospi float1
kernel_name: test_1_cospi_float
global_size: 9 0 0

arg_out: 0 buffer float[9] 1.0 0.22058417469052433 -0.6188200100712984 0.6296812985759392 -0.9257320367427456 1.0 1.0 1.0 nan  tolerance 4 ulp
arg_in: 1 buffer float[9] 0.0 1.5707963267948966 4.71238898038469 6.283185307179586 1.12345 1048576.0 16777216.0 1.329227995784916e+36 nan 

[test]
name: cospi float2
kernel_name: test_2_cospi_float
global_size: 9 0 0

arg_out: 0 buffer float[18] 1.0 1.0 0.22058417469052433 0.22058417469052433 -0.6188200100712984 -0.6188200100712984 0.6296812985759392 0.6296812985759392 -0.9257320367427456 -0.9257320367427456 1.0 1.0 1.0 1.0 1.0 1.0 nan nan  tolerance 4 ulp
arg_in: 1 buffer float[18] 0.0 0.0 1.5707963267948966 1.5707963267948966 4.71238898038469 4.71238898038469 6.283185307179586 6.283185307179586 1.12345 1.12345 1048576.0 1048576.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 nan nan 

[test]
name: cospi float4
kernel_name: test_4_cospi_float
global_size: 9 0 0

arg_out: 0 buffer float[36] 1.0 1.0 1.0 1.0 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[36] 0.0 0.0 0.0 0.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 1.12345 1.12345 1.12345 1.12345 1048576.0 1048576.0 1048576.0 1048576.0 16777216.0 16777216.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 nan nan nan nan 

[test]
name: cospi float8
kernel_name: test_8_cospi_float
global_size: 9 0 0

arg_out: 0 buffer float[72] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[72] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 nan nan nan nan nan nan nan nan 

[test]
name: cospi float16
kernel_name: test_16_cospi_float
global_size: 9 0 0

arg_out: 0 buffer float[144] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 0.22058417469052433 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 -0.6188200100712984 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 0.6296812985759392 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 -0.9257320367427456 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[144] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 4.71238898038469 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_cospi_float(global float* out, global float* in0){
  out[get_global_id(0)] = cospi(in0[get_global_id(0)]);
}

kernel void test_2_cospi_float(global float* out, global float* in0){
  vstore2(cospi(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_cospi_float(global float* out, global float* in0){
  vstore4(cospi(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_cospi_float(global float* out, global float* in0){
  vstore8(cospi(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_cospi_float(global float* out, global float* in0){
  vstore16(cospi(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

