/*!
[config]
name: Test float cosh built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: cosh float1
kernel_name: test_1_cosh_float
global_size: 5 0 0

arg_out: 0 buffer float[5] 1.0 1.0076304736991977 inf inf nan  tolerance 4 ulp
arg_in: 1 buffer float[5] 0.0 0.123456789 inf -inf nan 

[test]
name: cosh float2
kernel_name: test_2_cosh_float
global_size: 5 0 0

arg_out: 0 buffer float[10] 1.0 1.0 1.0076304736991977 1.0076304736991977 inf inf inf inf nan nan  tolerance 4 ulp
arg_in: 1 buffer float[10] 0.0 0.0 0.123456789 0.123456789 inf inf -inf -inf nan nan 

[test]
name: cosh float4
kernel_name: test_4_cosh_float
global_size: 5 0 0

arg_out: 0 buffer float[20] 1.0 1.0 1.0 1.0 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 inf inf inf inf inf inf inf inf nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[20] 0.0 0.0 0.0 0.0 0.123456789 0.123456789 0.123456789 0.123456789 inf inf inf inf -inf -inf -inf -inf nan nan nan nan 

[test]
name: cosh float8
kernel_name: test_8_cosh_float
global_size: 5 0 0

arg_out: 0 buffer float[40] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[40] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf nan nan nan nan nan nan nan nan 

[test]
name: cosh float16
kernel_name: test_16_cosh_float
global_size: 5 0 0

arg_out: 0 buffer float[80] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 1.0076304736991977 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[80] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_cosh_float(global float* out, global float* in0){
  out[get_global_id(0)] = cosh(in0[get_global_id(0)]);
}

kernel void test_2_cosh_float(global float* out, global float* in0){
  vstore2(cosh(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_cosh_float(global float* out, global float* in0){
  vstore4(cosh(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_cosh_float(global float* out, global float* in0){
  vstore8(cosh(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_cosh_float(global float* out, global float* in0){
  vstore16(cosh(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

