/*!
[config]
name: Test float cos built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: cos float1
kernel_name: test_1_cos_float
global_size: 12 0 0

arg_out: 0 buffer float[12] 1.0 -4.371139000186241e-08 -1.0 1.1924880638503055e-08 1.0 0.43257451305884403 0.7539022543433046 -0.14550003380861354 0.943808393901312 0.6263229832915329 -0.9258790228548379 nan  tolerance 4 ulp
arg_in: 1 buffer float[12] 0.0 1.5707963705062866 3.141592653589793 4.71238911151886 6.283185307179586 1.12345 7 8 1048576.0 16777216.0 1.329227995784916e+36 nan 

[test]
name: cos float2
kernel_name: test_2_cos_float
global_size: 12 0 0

arg_out: 0 buffer float[24] 1.0 1.0 -4.371139000186241e-08 -4.371139000186241e-08 -1.0 -1.0 1.1924880638503055e-08 1.1924880638503055e-08 1.0 1.0 0.43257451305884403 0.43257451305884403 0.7539022543433046 0.7539022543433046 -0.14550003380861354 -0.14550003380861354 0.943808393901312 0.943808393901312 0.6263229832915329 0.6263229832915329 -0.9258790228548379 -0.9258790228548379 nan nan  tolerance 4 ulp
arg_in: 1 buffer float[24] 0.0 0.0 1.5707963705062866 1.5707963705062866 3.141592653589793 3.141592653589793 4.71238911151886 4.71238911151886 6.283185307179586 6.283185307179586 1.12345 1.12345 7 7 8 8 1048576.0 1048576.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 nan nan 

[test]
name: cos float4
kernel_name: test_4_cos_float
global_size: 12 0 0

arg_out: 0 buffer float[48] 1.0 1.0 1.0 1.0 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -1.0 -1.0 -1.0 -1.0 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.0 1.0 1.0 1.0 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[48] 0.0 0.0 0.0 0.0 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 1.12345 1.12345 1.12345 1.12345 7 7 7 7 8 8 8 8 1048576.0 1048576.0 1048576.0 1048576.0 16777216.0 16777216.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 nan nan nan nan 

[test]
name: cos float8
kernel_name: test_8_cos_float
global_size: 12 0 0

arg_out: 0 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 7 7 7 7 7 7 7 7 8 8 8 8 8 8 8 8 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 nan nan nan nan nan nan nan nan 

[test]
name: cos float16
kernel_name: test_16_cos_float
global_size: 12 0 0

arg_out: 0 buffer float[192] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -4.371139000186241e-08 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.1924880638503055e-08 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.43257451305884403 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 0.7539022543433046 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 -0.14550003380861354 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.943808393901312 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 0.6263229832915329 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 -0.9258790228548379 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[192] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 1.5707963705062866 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 4.71238911151886 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 1048576.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 16777216.0 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 1.329227995784916e+36 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_cos_float(global float* out, global float* in0){
  out[get_global_id(0)] = cos(in0[get_global_id(0)]);
}

kernel void test_2_cos_float(global float* out, global float* in0){
  vstore2(cos(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_cos_float(global float* out, global float* in0){
  vstore4(cos(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_cos_float(global float* out, global float* in0){
  vstore8(cos(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_cos_float(global float* out, global float* in0){
  vstore16(cos(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

