/*!
[config]
name: Test float copysign built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: copysign float1
kernel_name: test_1_copysign_float
global_size: 9 0 0

arg_out: 0 buffer float[9] 0.0 -0.0 1.0 -1.0 nan nan -nan -inf inf  tolerance 0 ulp
arg_in: 1 buffer float[9] 0.0 0.0 1.0 -1.0 nan -4.0 nan inf -inf 
arg_in: 2 buffer float[9] 1.0 -1.0 2.0 -2.0 nan nan -4.0 -3.0 inf 

[test]
name: copysign float2
kernel_name: test_2_copysign_float
global_size: 9 0 0

arg_out: 0 buffer float[18] 0.0 0.0 -0.0 -0.0 1.0 1.0 -1.0 -1.0 nan nan nan nan -nan -nan -inf -inf inf inf  tolerance 0 ulp
arg_in: 1 buffer float[18] 0.0 0.0 0.0 0.0 1.0 1.0 -1.0 -1.0 nan nan -4.0 -4.0 nan nan inf inf -inf -inf 
arg_in: 2 buffer float[18] 1.0 1.0 -1.0 -1.0 2.0 2.0 -2.0 -2.0 nan nan nan nan -4.0 -4.0 -3.0 -3.0 inf inf 

[test]
name: copysign float4
kernel_name: test_4_copysign_float
global_size: 9 0 0

arg_out: 0 buffer float[36] 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan -nan -nan -nan -nan -inf -inf -inf -inf inf inf inf inf  tolerance 0 ulp
arg_in: 1 buffer float[36] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan -4.0 -4.0 -4.0 -4.0 nan nan nan nan inf inf inf inf -inf -inf -inf -inf 
arg_in: 2 buffer float[36] 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 2.0 2.0 2.0 2.0 -2.0 -2.0 -2.0 -2.0 nan nan nan nan nan nan nan nan -4.0 -4.0 -4.0 -4.0 -3.0 -3.0 -3.0 -3.0 inf inf inf inf 

[test]
name: copysign float8
kernel_name: test_8_copysign_float
global_size: 9 0 0

arg_out: 0 buffer float[72] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -nan -nan -nan -nan -nan -nan -nan -nan -inf -inf -inf -inf -inf -inf -inf -inf inf inf inf inf inf inf inf inf  tolerance 0 ulp
arg_in: 1 buffer float[72] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf 
arg_in: 2 buffer float[72] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 inf inf inf inf inf inf inf inf 

[test]
name: copysign float16
kernel_name: test_16_copysign_float
global_size: 9 0 0

arg_out: 0 buffer float[144] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf  tolerance 0 ulp
arg_in: 1 buffer float[144] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 
arg_in: 2 buffer float[144] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 -2.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -4.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 

!*/

kernel void test_1_copysign_float(global float* out, global float* in0, global float* in1){
  out[get_global_id(0)] = copysign(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_copysign_float(global float* out, global float* in0, global float* in1){
  vstore2(copysign(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_copysign_float(global float* out, global float* in0, global float* in1){
  vstore4(copysign(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_copysign_float(global float* out, global float* in0, global float* in1){
  vstore8(copysign(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_copysign_float(global float* out, global float* in0, global float* in1){
  vstore16(copysign(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

