/*!
[config]
name: Test float ceil built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: ceil float1
kernel_name: test_1_ceil_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 1.0 0.0 0.0 -0.0 nan -3.0  tolerance 0 ulp
arg_in: 1 buffer float[6] 0.5 -0.5 0.0 -0.0 nan -3.99 

[test]
name: ceil float2
kernel_name: test_2_ceil_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 1.0 1.0 0.0 0.0 0.0 0.0 -0.0 -0.0 nan nan -3.0 -3.0  tolerance 0 ulp
arg_in: 1 buffer float[12] 0.5 0.5 -0.5 -0.5 0.0 0.0 -0.0 -0.0 nan nan -3.99 -3.99 

[test]
name: ceil float4
kernel_name: test_4_ceil_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan -3.0 -3.0 -3.0 -3.0  tolerance 0 ulp
arg_in: 1 buffer float[24] 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan -3.99 -3.99 -3.99 -3.99 

[test]
name: ceil float8
kernel_name: test_8_ceil_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan nan nan nan nan -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0  tolerance 0 ulp
arg_in: 1 buffer float[48] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan nan nan nan nan -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 

[test]
name: ceil float16
kernel_name: test_16_ceil_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0  tolerance 0 ulp
arg_in: 1 buffer float[96] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 

!*/

kernel void test_1_ceil_float(global float* out, global float* in0){
  out[get_global_id(0)] = ceil(in0[get_global_id(0)]);
}

kernel void test_2_ceil_float(global float* out, global float* in0){
  vstore2(ceil(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_ceil_float(global float* out, global float* in0){
  vstore4(ceil(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_ceil_float(global float* out, global float* in0){
  vstore8(ceil(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_ceil_float(global float* out, global float* in0){
  vstore16(ceil(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

