/*!
[config]
name: Test float cbrt built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: cbrt float1
kernel_name: test_1_cbrt_float
global_size: 5 0 0

arg_out: 0 buffer float[5] 3.0 -1.0 nan inf 0.4979338592181745  tolerance 2 ulp
arg_in: 1 buffer float[5] 27.0 -1.0 nan inf 0.123456789 

[test]
name: cbrt float2
kernel_name: test_2_cbrt_float
global_size: 5 0 0

arg_out: 0 buffer float[10] 3.0 3.0 -1.0 -1.0 nan nan inf inf 0.4979338592181745 0.4979338592181745  tolerance 2 ulp
arg_in: 1 buffer float[10] 27.0 27.0 -1.0 -1.0 nan nan inf inf 0.123456789 0.123456789 

[test]
name: cbrt float4
kernel_name: test_4_cbrt_float
global_size: 5 0 0

arg_out: 0 buffer float[20] 3.0 3.0 3.0 3.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan inf inf inf inf 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745  tolerance 2 ulp
arg_in: 1 buffer float[20] 27.0 27.0 27.0 27.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan inf inf inf inf 0.123456789 0.123456789 0.123456789 0.123456789 

[test]
name: cbrt float8
kernel_name: test_8_cbrt_float
global_size: 5 0 0

arg_out: 0 buffer float[40] 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745  tolerance 2 ulp
arg_in: 1 buffer float[40] 27.0 27.0 27.0 27.0 27.0 27.0 27.0 27.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 

[test]
name: cbrt float16
kernel_name: test_16_cbrt_float
global_size: 5 0 0

arg_out: 0 buffer float[80] 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745 0.4979338592181745  tolerance 2 ulp
arg_in: 1 buffer float[80] 27.0 27.0 27.0 27.0 27.0 27.0 27.0 27.0 27.0 27.0 27.0 27.0 27.0 27.0 27.0 27.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 

!*/

kernel void test_1_cbrt_float(global float* out, global float* in0){
  out[get_global_id(0)] = cbrt(in0[get_global_id(0)]);
}

kernel void test_2_cbrt_float(global float* out, global float* in0){
  vstore2(cbrt(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_cbrt_float(global float* out, global float* in0){
  vstore4(cbrt(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_cbrt_float(global float* out, global float* in0){
  vstore8(cbrt(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_cbrt_float(global float* out, global float* in0){
  vstore16(cbrt(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

