/*!
[config]
name: Test float atanpi built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: atanpi float1
kernel_name: test_1_atanpi_float
global_size: 7 0 0

arg_out: 0 buffer float[7] 0.0 -0.0 0.2536887655657856 -0.2536887655657856 nan 0.5 -0.5  tolerance 5 ulp
arg_in: 1 buffer float[7] 0.0 -0.0 1.02345 -1.02345 nan inf -inf 

[test]
name: atanpi float2
kernel_name: test_2_atanpi_float
global_size: 7 0 0

arg_out: 0 buffer float[14] 0.0 0.0 -0.0 -0.0 0.2536887655657856 0.2536887655657856 -0.2536887655657856 -0.2536887655657856 nan nan 0.5 0.5 -0.5 -0.5  tolerance 5 ulp
arg_in: 1 buffer float[14] 0.0 0.0 -0.0 -0.0 1.02345 1.02345 -1.02345 -1.02345 nan nan inf inf -inf -inf 

[test]
name: atanpi float4
kernel_name: test_4_atanpi_float
global_size: 7 0 0

arg_out: 0 buffer float[28] 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 nan nan nan nan 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5  tolerance 5 ulp
arg_in: 1 buffer float[28] 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 1.02345 1.02345 1.02345 1.02345 -1.02345 -1.02345 -1.02345 -1.02345 nan nan nan nan inf inf inf inf -inf -inf -inf -inf 

[test]
name: atanpi float8
kernel_name: test_8_atanpi_float
global_size: 7 0 0

arg_out: 0 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 nan nan nan nan nan nan nan nan 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5  tolerance 5 ulp
arg_in: 1 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 1.02345 1.02345 1.02345 1.02345 1.02345 1.02345 1.02345 1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf 

[test]
name: atanpi float16
kernel_name: test_16_atanpi_float
global_size: 7 0 0

arg_out: 0 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 -0.2536887655657856 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5  tolerance 5 ulp
arg_in: 1 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 1.02345 1.02345 1.02345 1.02345 1.02345 1.02345 1.02345 1.02345 1.02345 1.02345 1.02345 1.02345 1.02345 1.02345 1.02345 1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 -1.02345 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf 

!*/

kernel void test_1_atanpi_float(global float* out, global float* in0){
  out[get_global_id(0)] = atanpi(in0[get_global_id(0)]);
}

kernel void test_2_atanpi_float(global float* out, global float* in0){
  vstore2(atanpi(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_atanpi_float(global float* out, global float* in0){
  vstore4(atanpi(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_atanpi_float(global float* out, global float* in0){
  vstore8(atanpi(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_atanpi_float(global float* out, global float* in0){
  vstore16(atanpi(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

