/*!
[config]
name: Test float atanh built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: atanh float1
kernel_name: test_1_atanh_float
global_size: 5 0 0

arg_out: 0 buffer float[5] 0.0 inf -inf nan 0.12408981359692224  tolerance 5 ulp
arg_in: 1 buffer float[5] 0.0 1.0 -1.0 nan 0.123456789 

[test]
name: atanh float2
kernel_name: test_2_atanh_float
global_size: 5 0 0

arg_out: 0 buffer float[10] 0.0 0.0 inf inf -inf -inf nan nan 0.12408981359692224 0.12408981359692224  tolerance 5 ulp
arg_in: 1 buffer float[10] 0.0 0.0 1.0 1.0 -1.0 -1.0 nan nan 0.123456789 0.123456789 

[test]
name: atanh float4
kernel_name: test_4_atanh_float
global_size: 5 0 0

arg_out: 0 buffer float[20] 0.0 0.0 0.0 0.0 inf inf inf inf -inf -inf -inf -inf nan nan nan nan 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224  tolerance 5 ulp
arg_in: 1 buffer float[20] 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan 0.123456789 0.123456789 0.123456789 0.123456789 

[test]
name: atanh float8
kernel_name: test_8_atanh_float
global_size: 5 0 0

arg_out: 0 buffer float[40] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf nan nan nan nan nan nan nan nan 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224  tolerance 5 ulp
arg_in: 1 buffer float[40] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 

[test]
name: atanh float16
kernel_name: test_16_atanh_float
global_size: 5 0 0

arg_out: 0 buffer float[80] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224 0.12408981359692224  tolerance 5 ulp
arg_in: 1 buffer float[80] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 

!*/

kernel void test_1_atanh_float(global float* out, global float* in0){
  out[get_global_id(0)] = atanh(in0[get_global_id(0)]);
}

kernel void test_2_atanh_float(global float* out, global float* in0){
  vstore2(atanh(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_atanh_float(global float* out, global float* in0){
  vstore4(atanh(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_atanh_float(global float* out, global float* in0){
  vstore8(atanh(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_atanh_float(global float* out, global float* in0){
  vstore16(atanh(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

