/*!
[config]
name: Test float atan2pi built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: atan2pi float1
kernel_name: test_1_atan2pi_float
global_size: 3 0 0

arg_out: 0 buffer float[3] 0.0 0.03909754198943117 0.4999999991076626  tolerance 6 ulp
arg_in: 1 buffer float[3] 0.0 1.2345 35671470.0 
arg_in: 2 buffer float[3] 0.0 10.0 0.1 

[test]
name: atan2pi float2
kernel_name: test_2_atan2pi_float
global_size: 3 0 0

arg_out: 0 buffer float[6] 0.0 0.0 0.03909754198943117 0.03909754198943117 0.4999999991076626 0.4999999991076626  tolerance 6 ulp
arg_in: 1 buffer float[6] 0.0 0.0 1.2345 1.2345 35671470.0 35671470.0 
arg_in: 2 buffer float[6] 0.0 0.0 10.0 10.0 0.1 0.1 

[test]
name: atan2pi float4
kernel_name: test_4_atan2pi_float
global_size: 3 0 0

arg_out: 0 buffer float[12] 0.0 0.0 0.0 0.0 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626  tolerance 6 ulp
arg_in: 1 buffer float[12] 0.0 0.0 0.0 0.0 1.2345 1.2345 1.2345 1.2345 35671470.0 35671470.0 35671470.0 35671470.0 
arg_in: 2 buffer float[12] 0.0 0.0 0.0 0.0 10.0 10.0 10.0 10.0 0.1 0.1 0.1 0.1 

[test]
name: atan2pi float8
kernel_name: test_8_atan2pi_float
global_size: 3 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626  tolerance 6 ulp
arg_in: 1 buffer float[24] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.2345 1.2345 1.2345 1.2345 1.2345 1.2345 1.2345 1.2345 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 
arg_in: 2 buffer float[24] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 0.1 0.1 0.1 0.1 0.1 0.1 0.1 0.1 

[test]
name: atan2pi float16
kernel_name: test_16_atan2pi_float
global_size: 3 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.03909754198943117 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626 0.4999999991076626  tolerance 6 ulp
arg_in: 1 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.2345 1.2345 1.2345 1.2345 1.2345 1.2345 1.2345 1.2345 1.2345 1.2345 1.2345 1.2345 1.2345 1.2345 1.2345 1.2345 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 35671470.0 
arg_in: 2 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 0.1 0.1 0.1 0.1 0.1 0.1 0.1 0.1 0.1 0.1 0.1 0.1 0.1 0.1 0.1 0.1 

!*/

kernel void test_1_atan2pi_float(global float* out, global float* in0, global float* in1){
  out[get_global_id(0)] = atan2pi(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_atan2pi_float(global float* out, global float* in0, global float* in1){
  vstore2(atan2pi(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_atan2pi_float(global float* out, global float* in0, global float* in1){
  vstore4(atan2pi(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_atan2pi_float(global float* out, global float* in0, global float* in1){
  vstore8(atan2pi(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_atan2pi_float(global float* out, global float* in0, global float* in1){
  vstore16(atan2pi(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

