/*!
[config]
name: Test float atan built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: atan float1
kernel_name: test_1_atan_float
global_size: 3 0 0

arg_out: 0 buffer float[3] 0.0 0.12282855068741544 1.5707960464588184  tolerance 5 ulp
arg_in: 1 buffer float[3] 0.0 0.12345 3567147.0 

[test]
name: atan float2
kernel_name: test_2_atan_float
global_size: 3 0 0

arg_out: 0 buffer float[6] 0.0 0.0 0.12282855068741544 0.12282855068741544 1.5707960464588184 1.5707960464588184  tolerance 5 ulp
arg_in: 1 buffer float[6] 0.0 0.0 0.12345 0.12345 3567147.0 3567147.0 

[test]
name: atan float4
kernel_name: test_4_atan_float
global_size: 3 0 0

arg_out: 0 buffer float[12] 0.0 0.0 0.0 0.0 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184  tolerance 5 ulp
arg_in: 1 buffer float[12] 0.0 0.0 0.0 0.0 0.12345 0.12345 0.12345 0.12345 3567147.0 3567147.0 3567147.0 3567147.0 

[test]
name: atan float8
kernel_name: test_8_atan_float
global_size: 3 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184  tolerance 5 ulp
arg_in: 1 buffer float[24] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 

[test]
name: atan float16
kernel_name: test_16_atan_float
global_size: 3 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 0.12282855068741544 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184 1.5707960464588184  tolerance 5 ulp
arg_in: 1 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 3567147.0 

!*/

kernel void test_1_atan_float(global float* out, global float* in0){
  out[get_global_id(0)] = atan(in0[get_global_id(0)]);
}

kernel void test_2_atan_float(global float* out, global float* in0){
  vstore2(atan(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_atan_float(global float* out, global float* in0){
  vstore4(atan(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_atan_float(global float* out, global float* in0){
  vstore8(atan(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_atan_float(global float* out, global float* in0){
  vstore16(atan(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

