/*!
[config]
name: Test float asinpi built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: asinpi float1
kernel_name: test_1_asinpi_float
global_size: 5 0 0

arg_out: 0 buffer float[5] -0.5 0.0 0.5 0.03939585577768386 nan  tolerance 5 ulp
arg_in: 1 buffer float[5] -1.0 0.0 1.0 0.12345 nan 

[test]
name: asinpi float2
kernel_name: test_2_asinpi_float
global_size: 5 0 0

arg_out: 0 buffer float[10] -0.5 -0.5 0.0 0.0 0.5 0.5 0.03939585577768386 0.03939585577768386 nan nan  tolerance 5 ulp
arg_in: 1 buffer float[10] -1.0 -1.0 0.0 0.0 1.0 1.0 0.12345 0.12345 nan nan 

[test]
name: asinpi float4
kernel_name: test_4_asinpi_float
global_size: 5 0 0

arg_out: 0 buffer float[20] -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 nan nan nan nan  tolerance 5 ulp
arg_in: 1 buffer float[20] -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.12345 0.12345 0.12345 0.12345 nan nan nan nan 

[test]
name: asinpi float8
kernel_name: test_8_asinpi_float
global_size: 5 0 0

arg_out: 0 buffer float[40] -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 nan nan nan nan nan nan nan nan  tolerance 5 ulp
arg_in: 1 buffer float[40] -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 nan nan nan nan nan nan nan nan 

[test]
name: asinpi float16
kernel_name: test_16_asinpi_float
global_size: 5 0 0

arg_out: 0 buffer float[80] -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 0.03939585577768386 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 5 ulp
arg_in: 1 buffer float[80] -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_asinpi_float(global float* out, global float* in0){
  out[get_global_id(0)] = asinpi(in0[get_global_id(0)]);
}

kernel void test_2_asinpi_float(global float* out, global float* in0){
  vstore2(asinpi(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_asinpi_float(global float* out, global float* in0){
  vstore4(asinpi(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_asinpi_float(global float* out, global float* in0){
  vstore8(asinpi(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_asinpi_float(global float* out, global float* in0){
  vstore16(asinpi(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

