/*!
[config]
name: Test float asinh built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: asinh float1
kernel_name: test_1_asinh_float
global_size: 5 0 0

arg_out: 0 buffer float[5] 0.0 0.881373587019543 -0.9660294709285797 nan 19.324548946827917  tolerance 4 ulp
arg_in: 1 buffer float[5] 0.0 1.0 -1.12345 nan 123456789.01234 

[test]
name: asinh float2
kernel_name: test_2_asinh_float
global_size: 5 0 0

arg_out: 0 buffer float[10] 0.0 0.0 0.881373587019543 0.881373587019543 -0.9660294709285797 -0.9660294709285797 nan nan 19.324548946827917 19.324548946827917  tolerance 4 ulp
arg_in: 1 buffer float[10] 0.0 0.0 1.0 1.0 -1.12345 -1.12345 nan nan 123456789.01234 123456789.01234 

[test]
name: asinh float4
kernel_name: test_4_asinh_float
global_size: 5 0 0

arg_out: 0 buffer float[20] 0.0 0.0 0.0 0.0 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 nan nan nan nan 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917  tolerance 4 ulp
arg_in: 1 buffer float[20] 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 -1.12345 -1.12345 -1.12345 -1.12345 nan nan nan nan 123456789.01234 123456789.01234 123456789.01234 123456789.01234 

[test]
name: asinh float8
kernel_name: test_8_asinh_float
global_size: 5 0 0

arg_out: 0 buffer float[40] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 nan nan nan nan nan nan nan nan 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917  tolerance 4 ulp
arg_in: 1 buffer float[40] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 nan nan nan nan nan nan nan nan 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 

[test]
name: asinh float16
kernel_name: test_16_asinh_float
global_size: 5 0 0

arg_out: 0 buffer float[80] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 0.881373587019543 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 -0.9660294709285797 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917  tolerance 4 ulp
arg_in: 1 buffer float[80] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 -1.12345 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 

!*/

kernel void test_1_asinh_float(global float* out, global float* in0){
  out[get_global_id(0)] = asinh(in0[get_global_id(0)]);
}

kernel void test_2_asinh_float(global float* out, global float* in0){
  vstore2(asinh(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_asinh_float(global float* out, global float* in0){
  vstore4(asinh(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_asinh_float(global float* out, global float* in0){
  vstore8(asinh(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_asinh_float(global float* out, global float* in0){
  vstore16(asinh(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

