/*!
[config]
name: Test float asin built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: asin float1
kernel_name: test_1_asin_float
global_size: 5 0 0

arg_out: 0 buffer float[5] -1.5707963267948966 0.0 1.5707963267948966 0.12376573109305462 nan  tolerance 4 ulp
arg_in: 1 buffer float[5] -1.0 0.0 1.0 0.12345 nan 

[test]
name: asin float2
kernel_name: test_2_asin_float
global_size: 5 0 0

arg_out: 0 buffer float[10] -1.5707963267948966 -1.5707963267948966 0.0 0.0 1.5707963267948966 1.5707963267948966 0.12376573109305462 0.12376573109305462 nan nan  tolerance 4 ulp
arg_in: 1 buffer float[10] -1.0 -1.0 0.0 0.0 1.0 1.0 0.12345 0.12345 nan nan 

[test]
name: asin float4
kernel_name: test_4_asin_float
global_size: 5 0 0

arg_out: 0 buffer float[20] -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 0.0 0.0 0.0 0.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[20] -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.12345 0.12345 0.12345 0.12345 nan nan nan nan 

[test]
name: asin float8
kernel_name: test_8_asin_float
global_size: 5 0 0

arg_out: 0 buffer float[40] -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[40] -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 nan nan nan nan nan nan nan nan 

[test]
name: asin float16
kernel_name: test_16_asin_float
global_size: 5 0 0

arg_out: 0 buffer float[80] -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 -1.5707963267948966 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 0.12376573109305462 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[80] -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_asin_float(global float* out, global float* in0){
  out[get_global_id(0)] = asin(in0[get_global_id(0)]);
}

kernel void test_2_asin_float(global float* out, global float* in0){
  vstore2(asin(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_asin_float(global float* out, global float* in0){
  vstore4(asin(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_asin_float(global float* out, global float* in0){
  vstore8(asin(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_asin_float(global float* out, global float* in0){
  vstore16(asin(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

