/*!
[config]
name: Test float acospi built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: acospi float1
kernel_name: test_1_acospi_float
global_size: 5 0 0

arg_out: 0 buffer float[5] 1 0.5 0.0 0.4606041442223161 nan  tolerance 5 ulp
arg_in: 1 buffer float[5] -1.0 0.0 1.0 0.12345 nan 

[test]
name: acospi float2
kernel_name: test_2_acospi_float
global_size: 5 0 0

arg_out: 0 buffer float[10] 1 1 0.5 0.5 0.0 0.0 0.4606041442223161 0.4606041442223161 nan nan  tolerance 5 ulp
arg_in: 1 buffer float[10] -1.0 -1.0 0.0 0.0 1.0 1.0 0.12345 0.12345 nan nan 

[test]
name: acospi float4
kernel_name: test_4_acospi_float
global_size: 5 0 0

arg_out: 0 buffer float[20] 1 1 1 1 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 nan nan nan nan  tolerance 5 ulp
arg_in: 1 buffer float[20] -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.12345 0.12345 0.12345 0.12345 nan nan nan nan 

[test]
name: acospi float8
kernel_name: test_8_acospi_float
global_size: 5 0 0

arg_out: 0 buffer float[40] 1 1 1 1 1 1 1 1 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 nan nan nan nan nan nan nan nan  tolerance 5 ulp
arg_in: 1 buffer float[40] -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 nan nan nan nan nan nan nan nan 

[test]
name: acospi float16
kernel_name: test_16_acospi_float
global_size: 5 0 0

arg_out: 0 buffer float[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 0.4606041442223161 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 5 ulp
arg_in: 1 buffer float[80] -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_acospi_float(global float* out, global float* in0){
  out[get_global_id(0)] = acospi(in0[get_global_id(0)]);
}

kernel void test_2_acospi_float(global float* out, global float* in0){
  vstore2(acospi(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_acospi_float(global float* out, global float* in0){
  vstore4(acospi(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_acospi_float(global float* out, global float* in0){
  vstore8(acospi(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_acospi_float(global float* out, global float* in0){
  vstore16(acospi(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

