/*!
[config]
name: Test float acosh built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: acosh float1
kernel_name: test_1_acosh_float
global_size: 4 0 0

arg_out: 0 buffer float[4] 0.0 0.4919155491201052 nan 19.324548946827917  tolerance 4 ulp
arg_in: 1 buffer float[4] 1.0 1.12345 nan 123456789.01234 

[test]
name: acosh float2
kernel_name: test_2_acosh_float
global_size: 4 0 0

arg_out: 0 buffer float[8] 0.0 0.0 0.4919155491201052 0.4919155491201052 nan nan 19.324548946827917 19.324548946827917  tolerance 4 ulp
arg_in: 1 buffer float[8] 1.0 1.0 1.12345 1.12345 nan nan 123456789.01234 123456789.01234 

[test]
name: acosh float4
kernel_name: test_4_acosh_float
global_size: 4 0 0

arg_out: 0 buffer float[16] 0.0 0.0 0.0 0.0 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 nan nan nan nan 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917  tolerance 4 ulp
arg_in: 1 buffer float[16] 1.0 1.0 1.0 1.0 1.12345 1.12345 1.12345 1.12345 nan nan nan nan 123456789.01234 123456789.01234 123456789.01234 123456789.01234 

[test]
name: acosh float8
kernel_name: test_8_acosh_float
global_size: 4 0 0

arg_out: 0 buffer float[32] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 nan nan nan nan nan nan nan nan 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917  tolerance 4 ulp
arg_in: 1 buffer float[32] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 nan nan nan nan nan nan nan nan 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 

[test]
name: acosh float16
kernel_name: test_16_acosh_float
global_size: 4 0 0

arg_out: 0 buffer float[64] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 0.4919155491201052 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917 19.324548946827917  tolerance 4 ulp
arg_in: 1 buffer float[64] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 1.12345 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 123456789.01234 

!*/

kernel void test_1_acosh_float(global float* out, global float* in0){
  out[get_global_id(0)] = acosh(in0[get_global_id(0)]);
}

kernel void test_2_acosh_float(global float* out, global float* in0){
  vstore2(acosh(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_acosh_float(global float* out, global float* in0){
  vstore4(acosh(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_acosh_float(global float* out, global float* in0){
  vstore8(acosh(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_acosh_float(global float* out, global float* in0){
  vstore16(acosh(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

